/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy.mapper.invoker;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.core.common.Page;
import cn.sylinx.horm.core.common.Record;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.mapper.MapperMethodMetadata;
import cn.sylinx.horm.proxy.mapper.interceptor.MapperInvokerProxy;
import cn.sylinx.horm.proxy.mapper.invoker.BeanListMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.BeanPageMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.BeanQueryOneMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.DeleteMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.ExecuteMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.InsertMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.MapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.ObjectListMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.ObjectQueryOneMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.RecordListMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.RecordPageMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.RecordQueryOneMapperInvoker;
import cn.sylinx.horm.proxy.mapper.invoker.UpdateMapperInvoker;
import cn.sylinx.horm.proxy.mapper.parse.NamespaceContainer;
import cn.sylinx.horm.proxy.mapper.parse.SqlItem;
import cn.sylinx.horm.proxy.mapper.parse.SqlType;
import cn.sylinx.horm.util.Tuple;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MapperInvokerManager
extends Enum<MapperInvokerManager> {
    private static Set<Class<?>> primaryOrMappedWrapTypeOrFrequentType;
    private static final Map<String, MapperInvoker> mapperInvokerMaps;
    private static final Map<String, MapperInvoker> cachedmapperInvokerMaps;
    private static final /* synthetic */ MapperInvokerManager[] $VALUES;

    public static MapperInvokerManager[] values() {
        return (MapperInvokerManager[])$VALUES.clone();
    }

    public static MapperInvokerManager valueOf(String name) {
        return Enum.valueOf(MapperInvokerManager.class, name);
    }

    private static MapperInvoker maybeProxyed(MapperInvoker mapperInvoker) {
        return OrmConfigHolder.hasMapperInterceptor() ? MapperInvokerProxy.create(mapperInvoker) : mapperInvoker;
    }

    public static MapperInvoker getBy(MapperMethodMetadata methodMetadata) {
        String metaKey = methodMetadata.getMetaKey();
        if (cachedmapperInvokerMaps.containsKey(metaKey)) {
            return cachedmapperInvokerMaps.get(metaKey);
        }
        String mapperInvokerKey = MapperInvokerManager.parseMatchKey(methodMetadata);
        MapperInvoker mapperInvoker = mapperInvokerMaps.get(mapperInvokerKey);
        if (mapperInvoker == null) {
            throw new HORMException("no suitable mapper invoker");
        }
        cachedmapperInvokerMaps.put(metaKey, mapperInvoker);
        return mapperInvoker;
    }

    private static String parseMatchKey(MapperMethodMetadata methodMetadata) {
        Tuple t = NamespaceContainer.getMapper(methodMetadata.getMapperInterface(), methodMetadata.getMethodName());
        SqlItem sqlItem = (SqlItem)t.getObject(1);
        Class<?> returnType = methodMetadata.getReturnType();
        Class<?> truelyReturnType = methodMetadata.getTruelyReturnType();
        if (MapperInvokerManager.isQuery(sqlItem)) {
            StringBuilder sb = new StringBuilder();
            sb.append("QUERY.");
            if (returnType == List.class) {
                sb.append("LIST.");
                if (!MapperInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(truelyReturnType) && !MapperInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("BEAN");
                    return sb.toString();
                }
                if (MapperInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("RECORD");
                    return sb.toString();
                }
                if (MapperInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(truelyReturnType)) {
                    sb.append("OBJ");
                    return sb.toString();
                }
            }
            if (returnType == Page.class) {
                sb.append("PAGE.");
                if (MapperInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("RECORD");
                    return sb.toString();
                }
                if (!MapperInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("BEAN");
                    return sb.toString();
                }
            }
            if (returnType != List.class && returnType != Page.class) {
                sb.append("ONE.");
                if (!MapperInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(returnType) && !MapperInvokerManager.isRecordForTruelyReturnType(returnType)) {
                    sb.append("BEAN");
                    return sb.toString();
                }
                if (MapperInvokerManager.isRecordForTruelyReturnType(returnType)) {
                    sb.append("RECORD");
                    return sb.toString();
                }
                if (MapperInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(returnType)) {
                    sb.append("OBJ");
                    return sb.toString();
                }
            }
        }
        if (MapperInvokerManager.isUpdate(sqlItem)) {
            return "UPDATE.";
        }
        if (MapperInvokerManager.isExecute(sqlItem)) {
            return "EXECUTE.";
        }
        if (MapperInvokerManager.isInsert(sqlItem)) {
            return "INSERT.";
        }
        if (MapperInvokerManager.isDelete(sqlItem)) {
            return "DELETE.";
        }
        return "NONE";
    }

    private static boolean isRecordForTruelyReturnType(Class<?> truelyReturnType) {
        return truelyReturnType == Record.class;
    }

    private static boolean isPrimaryOrMappedWrapTypeOrFrequentType(Class<?> truelyReturnType) {
        return primaryOrMappedWrapTypeOrFrequentType.contains(truelyReturnType);
    }

    private static boolean isQuery(SqlItem sqlItem) {
        return SqlType.select == sqlItem.getSqlType();
    }

    private static boolean isInsert(SqlItem sqlItem) {
        return SqlType.insert == sqlItem.getSqlType();
    }

    private static boolean isUpdate(SqlItem sqlItem) {
        return SqlType.update == sqlItem.getSqlType();
    }

    private static boolean isExecute(SqlItem sqlItem) {
        return SqlType.execute == sqlItem.getSqlType();
    }

    private static boolean isDelete(SqlItem sqlItem) {
        return SqlType.delete == sqlItem.getSqlType();
    }

    private static /* synthetic */ MapperInvokerManager[] $values() {
        return new MapperInvokerManager[0];
    }

    static {
        $VALUES = MapperInvokerManager.$values();
        primaryOrMappedWrapTypeOrFrequentType = new HashSet(8);
        primaryOrMappedWrapTypeOrFrequentType.add(Boolean.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Boolean.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Byte.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Byte.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Character.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Character.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Short.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Short.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Integer.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Integer.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Long.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Long.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Float.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Float.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Double.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Double.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(String.class);
        primaryOrMappedWrapTypeOrFrequentType.add(BigInteger.class);
        primaryOrMappedWrapTypeOrFrequentType.add(BigDecimal.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Date.class);
        mapperInvokerMaps = new HashMap<String, MapperInvoker>();
        cachedmapperInvokerMaps = new HashMap<String, MapperInvoker>();
        String insertKey = "INSERT.";
        mapperInvokerMaps.put(insertKey, MapperInvokerManager.maybeProxyed(new InsertMapperInvoker()));
        String deleteKey = "DELETE.";
        mapperInvokerMaps.put(deleteKey, MapperInvokerManager.maybeProxyed(new DeleteMapperInvoker()));
        String updateKey = "UPDATE.";
        mapperInvokerMaps.put(updateKey, MapperInvokerManager.maybeProxyed(new UpdateMapperInvoker()));
        String executeKey = "EXECUTE.";
        mapperInvokerMaps.put(executeKey, MapperInvokerManager.maybeProxyed(new ExecuteMapperInvoker()));
        String queryKey1 = "QUERY.LIST.BEAN";
        mapperInvokerMaps.put(queryKey1, MapperInvokerManager.maybeProxyed(new BeanListMapperInvoker()));
        String queryKey2 = "QUERY.LIST.RECORD";
        mapperInvokerMaps.put(queryKey2, MapperInvokerManager.maybeProxyed(new RecordListMapperInvoker()));
        String queryKey3 = "QUERY.LIST.OBJ";
        mapperInvokerMaps.put(queryKey3, MapperInvokerManager.maybeProxyed(new ObjectListMapperInvoker()));
        String queryKey4 = "QUERY.PAGE.BEAN";
        mapperInvokerMaps.put(queryKey4, MapperInvokerManager.maybeProxyed(new BeanPageMapperInvoker()));
        String queryKey5 = "QUERY.PAGE.RECORD";
        mapperInvokerMaps.put(queryKey5, MapperInvokerManager.maybeProxyed(new RecordPageMapperInvoker()));
        String queryKey6 = "QUERY.ONE.BEAN";
        mapperInvokerMaps.put(queryKey6, MapperInvokerManager.maybeProxyed(new BeanQueryOneMapperInvoker()));
        String queryKey7 = "QUERY.ONE.RECORD";
        mapperInvokerMaps.put(queryKey7, MapperInvokerManager.maybeProxyed(new RecordQueryOneMapperInvoker()));
        String queryKey8 = "QUERY.ONE.OBJ";
        mapperInvokerMaps.put(queryKey8, MapperInvokerManager.maybeProxyed(new ObjectQueryOneMapperInvoker()));
    }
}

