/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.pool;

import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.EnumDbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.pool.DefaultDataSourceSelector;
import cn.sylinx.horm.pool.PoolType;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;

public final class DataSourceWrapperFactory
extends Enum<DataSourceWrapperFactory> {
    private static final /* synthetic */ DataSourceWrapperFactory[] $VALUES;

    public static DataSourceWrapperFactory[] values() {
        return (DataSourceWrapperFactory[])$VALUES.clone();
    }

    public static DataSourceWrapperFactory valueOf(String name) {
        return Enum.valueOf(DataSourceWrapperFactory.class, name);
    }

    public static NamedDataSource buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        String dbType = Optional.ofNullable(dsMap.get("dbtype")).orElse(EnumDbType.MYSQL.getValue()).toString();
        String pooltype = Optional.ofNullable(dsMap.get("pooltype")).orElse("").toString();
        String name = Optional.ofNullable(dsMap.get("name")).orElse("").toString();
        DataSource dataSource = new DefaultDataSourceSelector(dsMap, extConfig).select(DataSourceWrapperFactory.selectPoolType(pooltype));
        if (dataSource == null) {
            throw new HORMException("\u7f3a\u5c11\u6570\u636e\u5e93\u8fde\u63a5\u6c60\uff0c\u8bf7\u914d\u7f6eBeecp\u6216Druid\u6216TomcatJdbc\u6216BoneCP\u6216C3P0\u6216dbcp\u6216Hikari");
        }
        GLog.debug("dataSource:{} inited, config:{}", dataSource.getClass().getName(), dataSource);
        return NamedDataSource.create(dataSource, name, DbType.getDbType(dbType));
    }

    private static PoolType selectPoolType(String pooltype) {
        PoolType manuSelectPoolType = null;
        if (StrKit.isNotBlank(pooltype)) {
            manuSelectPoolType = PoolType.getPoolType(pooltype);
        }
        if (manuSelectPoolType != null && DataSourceWrapperFactory.isClassExist(manuSelectPoolType.getClassName())) {
            return manuSelectPoolType;
        }
        if (DataSourceWrapperFactory.isBeecpExist()) {
            return PoolType.Beecp;
        }
        if (DataSourceWrapperFactory.isHikariExist()) {
            return PoolType.Hikari;
        }
        if (DataSourceWrapperFactory.isDruidExist()) {
            return PoolType.Druid;
        }
        if (DataSourceWrapperFactory.isTomcatJdbcPoolExist()) {
            return PoolType.TomcatJdbc;
        }
        if (DataSourceWrapperFactory.isBoneCPExist()) {
            return PoolType.BoneCP;
        }
        if (DataSourceWrapperFactory.isC3P0Exist()) {
            return PoolType.C3P0;
        }
        if (DataSourceWrapperFactory.isDbcp2Exist()) {
            return PoolType.Dbcp2;
        }
        if (DataSourceWrapperFactory.isDbcpExist()) {
            return PoolType.Dbcp;
        }
        return null;
    }

    private static boolean isBeecpExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Beecp.getClassName());
    }

    private static boolean isDruidExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Druid.getClassName());
    }

    private static boolean isTomcatJdbcPoolExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.TomcatJdbc.getClassName());
    }

    private static boolean isDbcp2Exist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Dbcp2.getClassName());
    }

    private static boolean isDbcpExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Dbcp.getClassName());
    }

    private static boolean isC3P0Exist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.C3P0.getClassName());
    }

    private static boolean isBoneCPExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.BoneCP.getClassName());
    }

    private static boolean isHikariExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Hikari.getClassName());
    }

    private static boolean isClassExist(String className) {
        return ClassUtil.isClassExist(className);
    }

    private static /* synthetic */ DataSourceWrapperFactory[] $values() {
        return new DataSourceWrapperFactory[0];
    }

    static {
        $VALUES = DataSourceWrapperFactory.$values();
    }
}

