/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.pool;

import cn.sylinx.horm.dialect.EnumDbType;
import cn.sylinx.horm.util.GLog;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;

public abstract class AbstractDataSourceCreator<T extends DataSource> {
    public T create(Map<String, Object> dsMap) {
        String dbType = Optional.ofNullable(dsMap.get("dbtype")).orElseGet(EnumDbType.MYSQL::getValue).toString();
        String driverClassName = Optional.ofNullable(dsMap.get("driver")).orElseGet(() -> "").toString();
        String url = Optional.ofNullable(dsMap.get("url")).orElseGet(() -> "").toString();
        String username = Optional.ofNullable(dsMap.get("username")).orElseGet(() -> "").toString();
        String password = Optional.ofNullable(dsMap.get("password")).orElseGet(() -> "").toString();
        T ds = this.createBaseDataSource(driverClassName, url, username, password, dbType);
        Map extConfig = (Map)dsMap.get("config");
        if (extConfig != null && !extConfig.isEmpty()) {
            this.setExtendConfig(ds, extConfig);
        }
        return ds;
    }

    protected void setExtendConfig(T cds, Map<String, Object> extConfig) {
        for (Map.Entry<String, Object> entry : extConfig.entrySet()) {
            String attr = entry.getKey();
            String value = entry.getValue().toString();
            this.setExtendConfigValue(cds, attr, value);
        }
    }

    private Method getClassSetMethodInner(Class<?> t, String attr, Class<?> parameterType) {
        String methodName = "set" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
        try {
            return t.getDeclaredMethod(methodName, parameterType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method getClassSetMethod(Class<?> t, String attr) {
        Class[] parameterTypes;
        for (Class parameterType : parameterTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, String.class, Integer.class, Long.class, Boolean.class}) {
            Method m = this.getClassSetMethodInner(t, attr, parameterType);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private Method getDataSourceSetMethod(Class<?> t, String attr) {
        Class<?> tmpClass = t;
        Method m = this.getClassSetMethod(tmpClass, attr);
        while (m == null && !"java.lang.object".equalsIgnoreCase((tmpClass = tmpClass.getSuperclass()).getName())) {
            m = this.getClassSetMethod(tmpClass, attr);
        }
        if (m != null) {
            GLog.debug("\u5728\u7c7b:{}\u4e2d\u627e\u5230\u5c5e\u6027:{}", tmpClass.getName(), attr);
        }
        return m;
    }

    protected void setExtendConfigValue(Object t, String attr, String value) {
        try {
            Method m = this.getDataSourceSetMethod(t.getClass(), attr);
            if (m == null) {
                GLog.error("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u9879:{}", attr);
                return;
            }
            m.setAccessible(true);
            Class<?> type = m.getParameterTypes()[0];
            Object targetValue = value;
            if (type == Boolean.class || type == Boolean.TYPE) {
                targetValue = Boolean.valueOf(value);
            }
            if (type == Integer.class || type == Integer.TYPE) {
                targetValue = Integer.valueOf(value);
            }
            if (type == Long.class || type == Long.TYPE) {
                targetValue = Long.valueOf(value);
            }
            if (type == Short.class || type == Short.TYPE) {
                targetValue = Short.valueOf(value);
            }
            m.invoke(t, targetValue);
        }
        catch (Exception e) {
            GLog.error("setValue error", e);
        }
    }

    abstract T createBaseDataSource(String var1, String var2, String var3, String var4, String var5);
}

