/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.model.cache;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.model.anno.AttributeColumnMapping;
import cn.sylinx.horm.model.anno.Column;
import cn.sylinx.horm.model.anno.Model;
import cn.sylinx.horm.model.anno.PrimaryKey;
import cn.sylinx.horm.model.anno.Table;
import cn.sylinx.horm.model.anno.Version;
import cn.sylinx.horm.model.cache.ModelConst;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.model.strategy.Strategy;
import cn.sylinx.horm.model.strategy.UnderlinedStrategy;
import cn.sylinx.horm.model.util.ModelUtil;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.type.handler.UnknownTypeHandler;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ModelCacheManager
extends Enum<ModelCacheManager> {
    private static final Strategy DEFAULT_STRATEGY;
    private static final Map<String, ModelFabric> cached;
    private static final /* synthetic */ ModelCacheManager[] $VALUES;

    public static ModelCacheManager[] values() {
        return (ModelCacheManager[])$VALUES.clone();
    }

    public static ModelCacheManager valueOf(String name) {
        return Enum.valueOf(ModelCacheManager.class, name);
    }

    public static int cachedSize() {
        return cached.size();
    }

    public static ModelFabric getModelFabric(String clzStr) {
        Class<?> clz = null;
        try {
            clz = Class.forName(clzStr, false, ClassUtil.getDefaultClassLoader());
            return ModelCacheManager.getModelFabric(clz);
        }
        catch (ClassNotFoundException e) {
            GLog.error("getModelFabric error:", e);
            return null;
        }
    }

    public static ModelFabric getModelFabric(Class<?> clz) {
        ModelFabric mf = cached.get(clz.getName());
        if (mf == null) {
            try {
                mf = ModelCacheManager.cachedOneModel(clz);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clz.getName());
                cached.put(clz.getName(), mf);
            }
            catch (Exception e) {
                GLog.error("cachedOneModel error, clz:" + clz.getName(), e);
            }
        }
        return mf;
    }

    public static void init(Set<String> clzSets) {
        if (clzSets == null || clzSets.isEmpty()) {
            return;
        }
        for (String clzStr : clzSets) {
            try {
                Class<?> clz = Class.forName(clzStr, false, ClassUtil.getDefaultClassLoader());
                Model model = clz.getDeclaredAnnotation(Model.class);
                if (model == null) continue;
                ModelFabric mf = ModelCacheManager.cachedOneModel(clz);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clzStr);
                cached.put(clzStr, mf);
            }
            catch (Exception e) {
                GLog.error("init error", e);
            }
        }
        GLog.debug("\u6ce8\u518c@Model\u5bf9\u8c61\u5b8c\u6bd5\uff0c\u603b\u8ba1:{}", cached.size());
    }

    public static void initByClassSets(Set<Class<?>> clzSets) {
        for (Class<?> clz : clzSets) {
            Model model = clz.getDeclaredAnnotation(Model.class);
            if (model == null) continue;
            try {
                ModelFabric mf = ModelCacheManager.cachedOneModel(clz);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clz.getName());
                cached.put(clz.getName(), mf);
            }
            catch (Exception e) {
                GLog.error("initByClassSets error", e);
            }
        }
    }

    private static Map<String, Column> getFieldDescMap(List<Field> fields) {
        HashMap<String, Column> fieldDesc = new HashMap<String, Column>();
        for (Field f : fields) {
            Column cd = f.getAnnotation(Column.class);
            if (cd == null) continue;
            fieldDesc.put(f.getName(), cd);
        }
        return fieldDesc;
    }

    private static Map<String, TypeHandler<?>> getTypeHandlerMap(List<Field> fields) {
        HashMap typeHandlerMap = new HashMap();
        for (Field f : fields) {
            TypeHandler<?> typeHandlerObject;
            Class<? extends TypeHandler<?>> typeHandler;
            Column cd = f.getAnnotation(Column.class);
            if (cd == null || (typeHandler = cd.typeHandler()) == UnknownTypeHandler.class || (typeHandlerObject = ModelCacheManager.createTypeHandler(typeHandler)) == null) continue;
            typeHandlerMap.put(f.getName(), typeHandlerObject);
        }
        return typeHandlerMap;
    }

    private static TypeHandler<?> createTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        try {
            return typeHandler.newInstance();
        }
        catch (Exception e) {
            GLog.error("createTypeHandler error", e);
            return null;
        }
    }

    private static Field parseVersionField(List<Field> fields) {
        for (Field f : fields) {
            Version version = f.getAnnotation(Version.class);
            if (version == null || !Version.versionClassList.contains(f.getType())) continue;
            return f;
        }
        return null;
    }

    private static Map<String, Field> getFieldsMap(List<Field> fields) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field f : fields) {
            fieldMap.put(f.getName(), f);
            if (OrmConfigHolder.isCaseSensitive()) continue;
            fieldMap.put(f.getName().toUpperCase(), f);
        }
        return fieldMap;
    }

    public static void register(String className) {
        try {
            ModelCacheManager.register(Class.forName(className, false, ClassUtil.getDefaultClassLoader()));
        }
        catch (Exception e) {
            GLog.error("register model cache error", e);
        }
    }

    public static void register(Class<?> clz) {
        try {
            ModelCacheManager.cachedOneModel(clz);
            GLog.debug("register model cache:{}", clz);
        }
        catch (Exception e) {
            GLog.error("register model cache error", e);
        }
    }

    private static ModelFabric cachedOneModel(Class<?> clz) throws Exception {
        AttributeColumnMapping mapping = clz.getAnnotation(AttributeColumnMapping.class);
        Table table = clz.getAnnotation(Table.class);
        PrimaryKey pk = clz.getAnnotation(PrimaryKey.class);
        List<Field> fields = ModelUtil.getObjectAllFields(clz);
        Map<String, Field> fieldMap = ModelCacheManager.getFieldsMap(fields);
        Map<String, Column> fieldDesc = ModelCacheManager.getFieldDescMap(fields);
        Map<String, TypeHandler<?>> typeHandlerMap = ModelCacheManager.getTypeHandlerMap(fields);
        Field versionField = ModelCacheManager.parseVersionField(fields);
        ModelFabric mf = new ModelFabric();
        mf.setClz(clz);
        mf.setPrimaryKey(pk);
        mf.setTable(table);
        mf.setFields(fields);
        mf.setFieldMap(fieldMap);
        mf.setFieldDesc(fieldDesc);
        mf.setTypeHandlerMap(typeHandlerMap);
        mf.setMapping(mapping);
        mf.setVersionField(versionField);
        HashMap<String, String> attrMapping = new HashMap<String, String>();
        HashMap<String, String> rawAttrMapping = new HashMap<String, String>();
        if (mapping != null) {
            Strategy as = mapping.strategy().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            rawAttrMapping.putAll(as.createRawAttrMapping(mf));
            attrMapping.putAll(as.createAttrMapping(mf));
        } else {
            Strategy globalStrategy = ModelConst.ME.getMappingStrategy();
            if (globalStrategy == null) {
                rawAttrMapping.putAll(DEFAULT_STRATEGY.createRawAttrMapping(mf));
                attrMapping.putAll(DEFAULT_STRATEGY.createAttrMapping(mf));
            } else {
                rawAttrMapping.putAll(globalStrategy.createRawAttrMapping(mf));
                attrMapping.putAll(globalStrategy.createAttrMapping(mf));
            }
        }
        mf.setRawAttrMapping(rawAttrMapping);
        mf.setAttrMapping(attrMapping);
        mf.setJdbcMapping(mf.createJdbcMapping());
        return mf;
    }

    public static void clear() {
        Set<Map.Entry<String, ModelFabric>> entries = cached.entrySet();
        for (Map.Entry<String, ModelFabric> item : entries) {
            item.getValue().clear();
        }
        cached.clear();
    }

    private static /* synthetic */ ModelCacheManager[] $values() {
        return new ModelCacheManager[0];
    }

    static {
        $VALUES = ModelCacheManager.$values();
        DEFAULT_STRATEGY = new UnderlinedStrategy();
        cached = new ConcurrentHashMap<String, ModelFabric>();
    }
}

