/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.dialect.sql.DefaultSqlBuilder;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OracleSqlBuilder
extends DefaultSqlBuilder {
    OracleSqlBuilder() {
    }

    @Override
    protected String[] getEscapeChar() {
        return new String[]{"\"", "\""};
    }

    @Override
    protected boolean toUpperCase() {
        return true;
    }

    @Override
    public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {
        String sqlCount = "SELECT count(1) as totalCount from (" + preSql + ")";
        int offsetBegin = pageSize * (pageNumber - 1);
        int offsetEnd = offsetBegin + pageSize;
        String sqlLimit = "SELECT /*+ FIRST_ROWS */ * FROM (SELECT A.*, ROWNUM RN FROM (" + preSql + ") A  WHERE ROWNUM <= ?) WHERE RN > ? ";
        Object[] params = new Object[]{offsetEnd, offsetBegin};
        return Tuple.apply(sqlCount, sqlLimit, params);
    }

    @Override
    public String buildValidateQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String getTable(Class<?> clz) {
        String table = ModelCacheUtil.getModelFabric(clz).getTableName();
        return table.toUpperCase();
    }

    @Override
    public String getTableColumn(Class<?> clz, String prop) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrMap = mf.getAttrMapping();
        String column = attrMap.get(prop);
        if (column == null) {
            column = prop;
        }
        return column.toUpperCase();
    }

    @Override
    public Tuple buildSelectSQL(FS<?> fluentSql) {
        String limitSql;
        String orderBy;
        String groupBy;
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("SELECT");
        if (fluentSql.isDistinct()) {
            sql.append(" DISTINCT");
        }
        String singleField = null;
        Class singleFieldClass = null;
        if (fluentSql.isSingleField()) {
            if (StrKit.isBlank(fluentSql.getSelectColumns()) && StrKit.isBlank(fluentSql.getSelectExpressionColumns())) {
                throw new HORMException("need one column at least");
            }
            singleFieldClass = Object.class;
            if (StrKit.isNotBlank(fluentSql.getSelectColumns())) {
                singleField = fluentSql.getSelectColumns().split(",")[0].trim();
                String bingoAttr = null;
                Map<String, String> attrs = fluentSql.getAttrs();
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    if (!singleField.equals(entry.getKey()) && !singleField.equals(entry.getValue())) continue;
                    bingoAttr = entry.getKey();
                }
                if (bingoAttr == null) {
                    throw new HORMException("no field specified");
                }
                Map<String, Field> fieldMap = ModelCacheUtil.getModelFabric(fluentSql.getModelClass()).getFieldMap();
                singleFieldClass = fieldMap.get(bingoAttr).getType();
            }
        }
        boolean hasSelected = false;
        if (StrKit.isNotBlank(fluentSql.getSelectColumns())) {
            sql.append(' ').append(fluentSql.getSelectColumns()).append(' ');
            hasSelected = true;
        } else if (fluentSql.getExcludedColumns() != null && !fluentSql.getExcludedColumns().isEmpty()) {
            sql.append(' ').append(this.buildExcludedColumns(fluentSql.getModelClass(), fluentSql.getExcludedColumns(), true, fluentSql.getPreEscape(), fluentSql.getPostEscape())).append(' ');
            hasSelected = true;
        }
        if (StrKit.isNotBlank(fluentSql.getSelectExpressionColumns())) {
            sql.append(hasSelected ? "," : "").append(" ").append(fluentSql.getSelectExpressionColumns()).append(" ");
        } else if (!hasSelected) {
            sql.append(" * ");
        }
        sql.append("FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        if (StrKit.isNotBlank(groupBy = fluentSql.getGroupBySQL().toString())) {
            sql.append(" GROUP BY").append(groupBy);
        }
        if (StrKit.isNotBlank(orderBy = fluentSql.getOrderBySQL().toString())) {
            sql.append(" ORDER BY").append(orderBy);
        }
        if (StrKit.isNotBlank(limitSql = fluentSql.getLimitSQL().toString())) {
            sql.append(limitSql);
        }
        int len = fluentSql.getParamValues() == null || fluentSql.getParamValues().isEmpty() ? 0 : fluentSql.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            fluentSql.getParamValues().toArray(params);
        }
        return Tuple.apply(sql.toString(), params, singleFieldClass == null ? fluentSql.getModelClass() : singleFieldClass);
    }

    public String buildExcludedColumns(Class<?> clz, List<String> excludedColumns, boolean useSymbol, String preEscape, String postEscape) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrs = mf.getRawAttrMapping();
        HashSet<String> columns = new HashSet<String>();
        Set<Map.Entry<String, String>> kvsets = attrs.entrySet();
        for (Map.Entry<String, String> entry : kvsets) {
            if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue()) || excludedColumns.contains(entry.getValue().toLowerCase())) continue;
            columns.add(preEscape + entry.getValue().toUpperCase() + postEscape);
        }
        StringBuilder sb = new StringBuilder();
        columns.forEach(k -> sb.append((String)k).append(","));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

