/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.dialect.fs.PlainFS;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultPlainFlusentSqlBuildHelper {
    public static Tuple buildSelectSQL(PlainFS fluentSql) {
        String limitSql;
        String orderBy;
        String groupBy;
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("SELECT");
        if (fluentSql.isDistinct()) {
            sql.append(" DISTINCT");
        }
        boolean hasSelected = false;
        if (StrKit.isNotBlank(fluentSql.getSelectColumns())) {
            sql.append(' ').append(fluentSql.getSelectColumns()).append(' ');
            hasSelected = true;
        }
        if (StrKit.isNotBlank(fluentSql.getSelectExpressionColumns())) {
            sql.append(hasSelected ? "," : "").append(" ").append(fluentSql.getSelectExpressionColumns()).append(" ");
        } else if (!hasSelected) {
            sql.append(" * ");
        }
        sql.append("FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        if (StrKit.isNotBlank(groupBy = fluentSql.getGroupBySQL().toString())) {
            sql.append(" GROUP BY").append(groupBy);
        }
        if (StrKit.isNotBlank(orderBy = fluentSql.getOrderBySQL().toString())) {
            sql.append(" ORDER BY").append(orderBy);
        }
        if (StrKit.isNotBlank(limitSql = fluentSql.getLimitSQL().toString())) {
            sql.append(limitSql);
        }
        int len = fluentSql.getParamValues() == null || fluentSql.getParamValues().isEmpty() ? 0 : fluentSql.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            fluentSql.getParamValues().toArray(params);
        }
        return Tuple.apply(sql.toString(), params);
    }

    public static Pair buildUpdateSQL(PlainFS fluentSql) {
        ArrayList paramsUpdate = new ArrayList();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("UPDATE ").append(fluentSql.getTableName()).append(" SET ");
        StringBuilder setSQL = new StringBuilder();
        boolean gmtUpdated = false;
        if (null != fluentSql.getUpdateColumnExpression() && !fluentSql.getUpdateColumnExpression().isEmpty()) {
            fluentSql.getUpdateColumnExpression().forEach((key, value) -> setSQL.append((String)key).append(" = ").append((String)value).append(", "));
        }
        if (null == fluentSql.getUpdateColumns() || fluentSql.getUpdateColumns().isEmpty()) {
            throw new HORMException("update columns is empty");
        }
        fluentSql.getUpdateColumns().forEach((key, value) -> {
            if (value == null) {
                setSQL.append((String)key).append(" = NULL, ");
            } else {
                setSQL.append((String)key).append(" = ?, ");
                paramsUpdate.add(value);
            }
        });
        sql.append(setSQL.substring(0, setSQL.length() - 2));
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        List<Object> paramsListPre = fluentSql.getParamValues();
        if (paramsListPre == null) {
            paramsListPre = new ArrayList<Object>();
        }
        paramsListFinal.addAll(paramsUpdate);
        paramsListFinal.addAll(paramsListPre);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        return Pair.of(sql.toString(), params);
    }

    public static Pair buildInsertSQL(PlainFS fluentSql) {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder placeholder = new StringBuilder();
        ArrayList<Object> insertParams = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("INSERT INTO ").append(fluentSql.getTableName());
        boolean hasField = false;
        if (null == fluentSql.getUpdateColumns() || fluentSql.getUpdateColumns().isEmpty()) {
            throw new HORMException("update columns is empty");
        }
        Map<String, Object> uc = fluentSql.getUpdateColumns();
        Set<Map.Entry<String, Object>> entrySets = uc.entrySet();
        for (Map.Entry<String, Object> entry : entrySets) {
            columnNames.append(",").append(entry.getKey());
            placeholder.append(",?");
            insertParams.add(entry.getValue());
            hasField = true;
        }
        if (!hasField) {
            throw new HORMException("no insert field detected");
        }
        sql.append("(").append(columnNames.substring(1)).append(")").append(" VALUES (").append(placeholder.substring(1)).append(")");
        ArrayList paramsListFinal = new ArrayList(insertParams);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        return Pair.of(sql.toString(), params);
    }

    public static Pair buildDeleteSQL(PlainFS fluentSql) {
        ArrayList<Object> paramsDelete = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("DELETE FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
            List<Object> paramsListPre = fluentSql.getParamValues();
            if (paramsListPre == null) {
                paramsListPre = new ArrayList<Object>();
            }
            paramsDelete.addAll(paramsListPre);
        }
        ArrayList paramsListFinal = new ArrayList(paramsDelete);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        return Pair.of(sql.toString(), params);
    }

    public static Pair buildCountSQL(PlainFS fluentSql) {
        if (!fluentSql.isCount()) {
            throw new HORMException("not count sql");
        }
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("SELECT COUNT(*) ");
        sql.append("FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        int len = fluentSql.getParamValues() == null || fluentSql.getParamValues().isEmpty() ? 0 : fluentSql.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            fluentSql.getParamValues().toArray(params);
        }
        return Pair.apply((Object)sql.toString(), (Object)params);
    }
}

