/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.base.BaseModel;
import cn.sylinx.horm.model.base.Model;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultFlusentSqlBuildHelper {
    public static Tuple buildSelectSQL(FS<?> fluentSql) {
        String limitSql;
        String orderBy;
        String groupBy;
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("SELECT");
        if (fluentSql.isDistinct()) {
            sql.append(" DISTINCT");
        }
        String singleField = null;
        Class singleFieldClass = null;
        if (fluentSql.isSingleField()) {
            if (StrKit.isBlank(fluentSql.getSelectColumns()) && StrKit.isBlank(fluentSql.getSelectExpressionColumns())) {
                throw new HORMException("need one column at least");
            }
            singleFieldClass = Object.class;
            if (StrKit.isNotBlank(fluentSql.getSelectColumns())) {
                singleField = fluentSql.getSelectColumns().split(",")[0].trim();
                String bingoAttr = null;
                Map<String, String> attrs = fluentSql.getAttrs();
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    if (!singleField.equals(entry.getKey()) && !singleField.equals(entry.getValue())) continue;
                    bingoAttr = entry.getKey();
                }
                if (bingoAttr == null) {
                    throw new HORMException("no field specified");
                }
                Map<String, Field> fieldMap = ModelCacheUtil.getModelFabric(fluentSql.getModelClass()).getFieldMap();
                singleFieldClass = fieldMap.get(bingoAttr).getType();
            }
        }
        boolean hasSelected = false;
        if (StrKit.isNotBlank(fluentSql.getSelectColumns())) {
            sql.append(' ').append(fluentSql.getSelectColumns()).append(' ');
            hasSelected = true;
        } else if (fluentSql.getExcludedColumns() != null && !fluentSql.getExcludedColumns().isEmpty()) {
            sql.append(' ').append(DefaultFlusentSqlBuildHelper.buildExcludedColumns(fluentSql.getModelClass(), fluentSql.getExcludedColumns(), true, fluentSql.getPreEscape(), fluentSql.getPostEscape())).append(' ');
            hasSelected = true;
        }
        if (StrKit.isNotBlank(fluentSql.getSelectExpressionColumns())) {
            sql.append(hasSelected ? "," : "").append(" ").append(fluentSql.getSelectExpressionColumns()).append(" ");
        } else if (!hasSelected) {
            sql.append(" * ");
        }
        sql.append("FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        if (StrKit.isNotBlank(groupBy = fluentSql.getGroupBySQL().toString())) {
            sql.append(" GROUP BY").append(groupBy);
        }
        if (StrKit.isNotBlank(orderBy = fluentSql.getOrderBySQL().toString())) {
            sql.append(" ORDER BY").append(orderBy);
        }
        if (StrKit.isNotBlank(limitSql = fluentSql.getLimitSQL().toString())) {
            sql.append(limitSql);
        }
        int len = fluentSql.getParamValues() == null || fluentSql.getParamValues().isEmpty() ? 0 : fluentSql.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            fluentSql.getParamValues().toArray(params);
        }
        return Tuple.apply(sql.toString(), params, singleFieldClass == null ? fluentSql.getModelClass() : singleFieldClass);
    }

    public static Pair buildUpdateSQL(FS<?> fluentSql) {
        String gmtModify;
        ArrayList<Object> paramsUpdate = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("UPDATE ").append(fluentSql.getTableName()).append(" SET ");
        StringBuilder setSQL = new StringBuilder();
        boolean gmtUpdated = false;
        if (null != fluentSql.getUpdateColumnExpression() && !fluentSql.getUpdateColumnExpression().isEmpty()) {
            fluentSql.getUpdateColumnExpression().forEach((key, value) -> setSQL.append((String)key).append(" = ").append((String)value).append(", "));
            if (BaseModel.class.isAssignableFrom(fluentSql.getModelClass())) {
                gmtModify = fluentSql.mapColumn("gmtModify");
                if (!fluentSql.getUpdateColumnExpression().containsKey(gmtModify)) {
                    setSQL.append(gmtModify).append(" = ?, ");
                    paramsUpdate.add(new Date());
                    gmtUpdated = true;
                }
            }
        }
        if (null != fluentSql.getUpdateColumns() && !fluentSql.getUpdateColumns().isEmpty()) {
            fluentSql.getUpdateColumns().forEach((key, value) -> {
                if (value == null) {
                    setSQL.append((String)key).append(" = NULL, ");
                } else {
                    setSQL.append((String)key).append(" = ?, ");
                    paramsUpdate.add(value);
                }
            });
            if (!gmtUpdated && BaseModel.class.isAssignableFrom(fluentSql.getModelClass())) {
                gmtModify = fluentSql.mapColumn("gmtModify");
                if (!fluentSql.getUpdateColumns().containsKey(gmtModify)) {
                    setSQL.append(gmtModify).append(" = ?, ");
                    paramsUpdate.add(new Date());
                }
            }
        } else if (null != fluentSql.getModel()) {
            ModelFabric mf = ModelCacheUtil.getModelFabric(fluentSql.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            Map<String, TypeHandler<?>> typeHandlerMap = mf.getTypeHandlerMap();
            Set<Object> nullableSets = new HashSet();
            if (fluentSql.getModel() instanceof Model) {
                nullableSets = ((Model)fluentSql.getModel()).getNullableFields();
            }
            if (fluentSql.getModel() instanceof BaseModel) {
                ((BaseModel)fluentSql.getModel()).setGmtModify(new Date());
            }
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(fluentSql.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null) continue;
                    boolean nullable = nullableSets.contains(fieldName);
                    if (v != null) {
                        setSQL.append(f).append(" = ?, ");
                        paramsUpdate.add(DefaultFlusentSqlBuildHelper.convertValue(typeHandlerMap.get(fieldName), v));
                        continue;
                    }
                    if (!nullable) continue;
                    setSQL.append(f).append(" = NULL, ");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HORMException("illegal argument or Access:", e);
            }
        }
        sql.append(setSQL, 0, setSQL.length() - 2);
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        List<Object> paramsListPre = fluentSql.getParamValues();
        if (paramsListPre == null) {
            paramsListPre = new ArrayList<Object>();
        }
        paramsListFinal.addAll(paramsUpdate);
        paramsListFinal.addAll(paramsListPre);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        return Pair.of(sql.toString(), params);
    }

    public static Pair buildInsertSQL(FS<?> fluentSql) {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder placeholder = new StringBuilder();
        ArrayList<Object> insertParams = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("INSERT INTO ").append(fluentSql.getTableName());
        boolean hasField = false;
        if (null != fluentSql.getUpdateColumns() && !fluentSql.getUpdateColumns().isEmpty()) {
            Map<String, Object> uc = fluentSql.getUpdateColumns();
            Set<Map.Entry<String, Object>> entrySets = uc.entrySet();
            for (Map.Entry<String, Object> entry : entrySets) {
                columnNames.append(",").append(entry.getKey());
                placeholder.append(",?");
                insertParams.add(entry.getValue());
                hasField = true;
            }
            if (BaseModel.class.isAssignableFrom(fluentSql.getModelClass())) {
                String gmtModify = fluentSql.mapColumn("gmtModify");
                if (!fluentSql.getUpdateColumns().containsKey(gmtModify)) {
                    columnNames.append(",").append(gmtModify);
                    placeholder.append(",?");
                    insertParams.add(new Date());
                }
                String gmtCreate = fluentSql.mapColumn("gmtCreate");
                if (!fluentSql.getUpdateColumns().containsKey(gmtCreate)) {
                    columnNames.append(",").append(gmtCreate);
                    placeholder.append(",?");
                    insertParams.add(new Date());
                }
            }
        } else if (null != fluentSql.getModel()) {
            ModelFabric mf = ModelCacheUtil.getModelFabric(fluentSql.getModelClass());
            Map<String, TypeHandler<?>> typeHandlerMap = mf.getTypeHandlerMap();
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            if (BaseModel.class.isAssignableFrom(fluentSql.getModelClass())) {
                Date c = new Date();
                ((BaseModel)fluentSql.getModel()).setGmtModify(c);
                ((BaseModel)fluentSql.getModel()).setGmtCreate(c);
            }
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(fluentSql.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null || v == null) continue;
                    columnNames.append(",").append(f);
                    placeholder.append(",?");
                    insertParams.add(DefaultFlusentSqlBuildHelper.convertValue(typeHandlerMap.get(fieldName), v));
                    hasField = true;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HORMException("illegal argument or Access:", e);
            }
        }
        if (!hasField) {
            throw new HORMException("no insert field detected");
        }
        sql.append("(").append(columnNames.substring(1)).append(")").append(" VALUES (").append(placeholder.substring(1)).append(")");
        ArrayList paramsListFinal = new ArrayList(insertParams);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        return Pair.of(sql.toString(), params);
    }

    public static Pair buildDeleteSQL(FS<?> fluentSql) {
        ArrayList<Object> paramsDelete = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("DELETE FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
            List<Object> paramsListPre = fluentSql.getParamValues();
            if (paramsListPre == null) {
                paramsListPre = new ArrayList<Object>();
            }
            paramsDelete.addAll(paramsListPre);
        } else if (null != fluentSql.getModel()) {
            StringBuilder columnNames = new StringBuilder();
            ModelFabric mf = ModelCacheUtil.getModelFabric(fluentSql.getModelClass());
            Map<String, TypeHandler<?>> typeHandlerMap = mf.getTypeHandlerMap();
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            String andStr = " AND ";
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(fluentSql.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null || v == null) continue;
                    columnNames.append(f).append(" = ?").append(andStr);
                    paramsDelete.add(DefaultFlusentSqlBuildHelper.convertValue(typeHandlerMap.get(fieldName), v));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HORMException("illegal argument or Access:", e);
            }
            if (columnNames.length() > 0) {
                sql.append(" WHERE ").append(columnNames, 0, columnNames.length() - andStr.length());
            }
        }
        ArrayList paramsListFinal = new ArrayList(paramsDelete);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        return Pair.of(sql.toString(), params);
    }

    public static Pair buildCountSQL(FS<?> fluentSql) {
        if (!fluentSql.isCount()) {
            throw new HORMException("not count sql");
        }
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(fluentSql.getHint())) {
            sql.append(fluentSql.getHint()).append(" ");
        }
        sql.append("SELECT COUNT(*) ");
        sql.append("FROM ").append(fluentSql.getTableName());
        if (fluentSql.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(fluentSql.getConditionSQL().substring(" AND ".length()));
        }
        int len = fluentSql.getParamValues() == null || fluentSql.getParamValues().isEmpty() ? 0 : fluentSql.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            fluentSql.getParamValues().toArray(params);
        }
        return Pair.apply((Object)sql.toString(), (Object)params);
    }

    public static String buildExcludedColumns(Class<?> clz, List<String> excludedColumns, boolean useSymbol, String preEscape, String postEscape) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrs = mf.getRawAttrMapping();
        HashSet<String> columns = new HashSet<String>();
        Set<Map.Entry<String, String>> kvsets = attrs.entrySet();
        for (Map.Entry<String, String> entry : kvsets) {
            if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue()) || excludedColumns.contains(entry.getValue().toLowerCase())) continue;
            if (useSymbol) {
                columns.add(preEscape + entry.getValue() + postEscape);
                continue;
            }
            columns.add(entry.getValue().toUpperCase());
        }
        StringBuilder sb = new StringBuilder();
        columns.forEach(k -> sb.append((String)k).append(","));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static Object convertValue(TypeHandler<?> typeHandler, Object v) {
        if (typeHandler == null) {
            return v;
        }
        TypedParameter tp = new TypedParameter();
        tp.setParameter(v);
        tp.setTypeHandler(typeHandler);
        return tp;
    }
}

