/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.EnumDbType;
import cn.sylinx.horm.dialect.fs.builder.DefaultFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.DerbyFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.DuckdbFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.FSBuilder;
import cn.sylinx.horm.dialect.fs.builder.HsqldbFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.MySqlFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.OracleFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.PostgreSqlFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.SqliteFSBuilder;
import cn.sylinx.horm.dialect.fs.builder.SqlserverFSBuilder;
import java.util.HashMap;
import java.util.Map;

public class FSBuilderFactory {
    private final Map<DbType, FSBuilder> registers = new HashMap<DbType, FSBuilder>();
    private static final FSBuilderFactory instance = new FSBuilderFactory();
    private final FSBuilder defaultFluentSqlCreator = new DefaultFSBuilder();

    public static FSBuilderFactory get() {
        return instance;
    }

    private FSBuilderFactory() {
        this.registerDefault();
    }

    private void registerDefault() {
        this.register(EnumDbType.MYSQL, new MySqlFSBuilder());
        this.register(EnumDbType.ORACLE, new OracleFSBuilder());
        this.register(EnumDbType.SQLSERVER, new SqlserverFSBuilder());
        this.register(EnumDbType.POSTGRESQL, new PostgreSqlFSBuilder());
        this.register(EnumDbType.DUCKDB, new DuckdbFSBuilder());
        this.register(EnumDbType.DERBY, new DerbyFSBuilder());
        this.register(EnumDbType.SQLITE, new SqliteFSBuilder());
        this.register(EnumDbType.HSQLDB, new HsqldbFSBuilder());
    }

    public void register(DbType dbType, FSBuilder sqlBuilder) {
        this.registers.put(dbType, sqlBuilder);
    }

    public FSBuilder getFSBuilder(DbType dbType) {
        FSBuilder sb = this.registers.get(dbType);
        if (sb == null) {
            return this.defaultFluentSqlCreator;
        }
        return sb;
    }
}

