/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.fs;

import cn.sylinx.horm.core.common.OrderBy;
import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class PlainFS {
    public static final String AND_STR = " AND ";
    public static final String BLANK_STR = "";
    protected StringBuilder conditionSQL = new StringBuilder();
    protected StringBuilder orderBySQL = new StringBuilder();
    protected StringBuilder groupBySQL = new StringBuilder();
    protected StringBuilder limitSQL = new StringBuilder();
    protected List<Object> paramValues = new ArrayList<Object>(8);
    protected Map<String, Object> updateColumns = new LinkedHashMap<String, Object>(8);
    protected Map<String, String> updateColumnExpression = new LinkedHashMap<String, String>(8);
    protected String selectColumns;
    protected String selectExpressionColumns;
    protected boolean distinct = false;
    protected boolean count = false;
    protected String[] primaryKeyColumn;
    protected String tableName;
    protected Map<String, TypeHandler<?>> typeHandlerMap = null;
    protected String preEscape;
    protected String postEscape;
    protected String hint;
    protected String tablePostfix = "";
    protected String tablePrefix = "";

    public static PlainFS of(String tableName) {
        return PlainFS.of(BLANK_STR, tableName, BLANK_STR);
    }

    public static PlainFS of(String tablePrefix, String tableName, String tablePostfix) {
        return new PlainFS().init(tablePrefix, tableName, tablePostfix);
    }

    public PlainFS init(String tablePrefix, String tableName, String tablePostfix) {
        return this.parse(tablePrefix, tableName, tablePostfix);
    }

    protected String[] getEscape() {
        return new String[]{BLANK_STR, BLANK_STR};
    }

    protected String getDefaultTableName() {
        return this.preEscape + this.tablePrefix + this.tableName + this.tablePostfix + this.postEscape;
    }

    private PlainFS parse(String tablePrefix, String tableName, String tablePostfix) {
        this.tablePrefix = tablePrefix == null ? BLANK_STR : tablePrefix.trim();
        this.tablePostfix = tablePostfix == null ? BLANK_STR : tablePostfix.trim();
        String[] escapes = this.getEscape();
        this.preEscape = escapes[0];
        this.postEscape = escapes[1];
        this.tableName = tableName;
        this.primaryKeyColumn = new String[]{"id"};
        if (this.typeHandlerMap == null) {
            this.typeHandlerMap = new HashMap();
        }
        return this;
    }

    public PlainFS setEscape(String preEscape, String postEscape) {
        this.preEscape = preEscape;
        this.postEscape = postEscape;
        return this;
    }

    public PlainFS select(String columns) {
        if (null != this.selectColumns) {
            throw new HORMException("Select method can only be called once.");
        }
        this.selectColumns = this.mapColumns(columns);
        return this;
    }

    public PlainFS selectExp(String exp) {
        if (null != this.selectExpressionColumns) {
            throw new HORMException("SelectExp method can only be called once.");
        }
        this.selectExpressionColumns = exp;
        return this;
    }

    public PlainFS select(String ... columnArray) {
        if (null != this.selectColumns) {
            throw new HORMException("Select method can only be called once.");
        }
        this.selectColumns = this.mapColumns(columnArray);
        return this;
    }

    public PlainFS hint(String hint) {
        this.hint = hint;
        return this;
    }

    public PlainFS distinct() {
        this.distinct = true;
        return this;
    }

    public PlainFS count() {
        this.count = true;
        return this;
    }

    private String mapColumns(String[] columnArray) {
        this.beforeCheck();
        if (columnArray == null || columnArray.length == 0) {
            return null;
        }
        StringBuilder mappedClumns = new StringBuilder();
        for (String column : columnArray) {
            mappedClumns.append(this.mapColumn(column.trim())).append(",");
        }
        mappedClumns.deleteCharAt(mappedClumns.length() - 1);
        return mappedClumns.toString();
    }

    private String mapColumns(String columns) {
        String[] columnArray;
        this.beforeCheck();
        if (StrKit.isBlank(columns)) {
            return null;
        }
        StringBuilder mappedClumns = new StringBuilder();
        for (String column : columnArray = columns.split(",")) {
            mappedClumns.append(this.mapColumn(column.trim())).append(",");
        }
        mappedClumns.deleteCharAt(mappedClumns.length() - 1);
        return mappedClumns.toString();
    }

    protected String mapColumn(String column) {
        return this.preEscape + column + this.postEscape;
    }

    public PlainFS where(String column) {
        String trueStatement = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueStatement);
        return this;
    }

    public PlainFS where() {
        this.conditionSQL.append(AND_STR);
        return this;
    }

    public PlainFS whereExp(String exp) {
        this.conditionSQL.append(AND_STR).append(exp);
        return this;
    }

    public PlainFS where(String column, Object value) {
        String trueStatement = this.mapColumn(column) + " = ?";
        this.conditionSQL.append(AND_STR).append(trueStatement);
        this.paramValues.add(this.convertValue(column, value));
        return this;
    }

    public PlainFS eq(Object value) {
        this.conditionSQL.append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS notNull() {
        this.conditionSQL.append(" IS NOT NULL");
        return this;
    }

    public PlainFS and(String column, Object value) {
        return this.where(column, value);
    }

    public PlainFS and(String column) {
        return this.where(column);
    }

    public PlainFS or(String column, Object value) {
        String trueStatement = this.mapColumn(column) + " = ?";
        this.conditionSQL.append(" OR (").append(trueStatement);
        this.conditionSQL.append(')');
        this.paramValues.add(this.convertValue(column, value));
        return this;
    }

    public PlainFS andNotEq(String column, Object value) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column)).append(" != ?");
        this.paramValues.add(this.convertValue(column, value));
        return this;
    }

    public PlainFS notEq(Object value) {
        this.conditionSQL.append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS andNotEmpty(String columnName) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" != ''");
        return this;
    }

    public PlainFS notEmpty(String columnName) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" != ''");
        return this;
    }

    public PlainFS notEmpty() {
        this.conditionSQL.append(" != ''");
        return this;
    }

    public PlainFS andNotNull(String columnName) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" IS NOT NULL");
        return this;
    }

    public PlainFS notNull(String columnName) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" IS NOT NULL");
        return this;
    }

    public PlainFS isNull() {
        this.conditionSQL.append(" IS NULL");
        return this;
    }

    public PlainFS isNull(String columnName) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" IS NULL");
        return this;
    }

    public PlainFS andIsNull(String columnName) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" IS NULL");
        return this;
    }

    public PlainFS limit(int size) {
        return this.limit(0, size);
    }

    public PlainFS limit(int offset, int size) {
        if (this.limitSQL.length() == 0) {
            this.limitSQL.append(" LIMIT ").append(offset).append(", ").append(size);
        }
        return this;
    }

    public PlainFS andLike(String columnName, Object value) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" LIKE ?");
        this.paramValues.add("%" + value + "%");
        return this;
    }

    public PlainFS like(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add("%" + value + "%");
        return this;
    }

    public PlainFS like(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(trueColumnName).append(" LIKE ?");
        this.paramValues.add("%" + value + "%");
        return this;
    }

    public PlainFS andLikeLeft(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" LIKE ?");
        this.paramValues.add("%" + value);
        return this;
    }

    public PlainFS likeLeft(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add("%" + value);
        return this;
    }

    public PlainFS likeLeft(String columnName, Object value) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" LIKE ?");
        this.paramValues.add("%" + value);
        return this;
    }

    public PlainFS andLikeRight(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" LIKE ?");
        this.paramValues.add(value + "%");
        return this;
    }

    public PlainFS likeRight(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add(value + "%");
        return this;
    }

    public PlainFS likeRight(String columnName, Object value) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" LIKE ?");
        this.paramValues.add(value + "%");
        return this;
    }

    public PlainFS andBetween(String columnName, Object a, Object b) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" BETWEEN ? and ?");
        this.paramValues.add(this.convertValue(columnName, a));
        this.paramValues.add(this.convertValue(columnName, b));
        return this;
    }

    public PlainFS andNotBetween(String columnName, Object a, Object b) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" NOT BETWEEN ? and ?");
        this.paramValues.add(this.convertValue(columnName, a));
        this.paramValues.add(this.convertValue(columnName, b));
        return this;
    }

    public PlainFS between(Object a, Object b) {
        this.conditionSQL.append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public PlainFS notBetween(Object a, Object b) {
        this.conditionSQL.append(" NOT BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public PlainFS between(String columnName, Object a, Object b) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" BETWEEN ? and ?");
        this.paramValues.add(this.convertValue(columnName, a));
        this.paramValues.add(this.convertValue(columnName, b));
        return this;
    }

    public PlainFS notBetween(String columnName, Object a, Object b) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" NOT BETWEEN ? and ?");
        this.paramValues.add(this.convertValue(columnName, a));
        this.paramValues.add(this.convertValue(columnName, b));
        return this;
    }

    public PlainFS andGt(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" > ?");
        this.paramValues.add(this.convertValue(columnName, value));
        return this;
    }

    public PlainFS gt(Object value) {
        this.conditionSQL.append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS gt(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(trueColumnName).append(" > ?");
        this.paramValues.add(this.convertValue(columnName, value));
        return this;
    }

    public PlainFS andGte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" >= ?");
        this.paramValues.add(this.convertValue(column, value));
        return this;
    }

    public PlainFS gte(Object value) {
        this.conditionSQL.append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS andLt(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS lt(Object value) {
        this.conditionSQL.append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS andLte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS lte(Object value) {
        this.conditionSQL.append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS gte(String column, Object value) {
        this.conditionSQL.append(this.mapColumn(column)).append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS lt(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS lte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS andIn(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public PlainFS andNotIn(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" NOT IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public PlainFS in(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public PlainFS notIn(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" NOT IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public PlainFS in(Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("Column: {}, query params is empty.", new Object[0]);
            return this;
        }
        this.conditionSQL.append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public PlainFS notIn(Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("Column: {}, query params is empty.", new Object[0]);
            return this;
        }
        this.conditionSQL.append(" NOT IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public <S> PlainFS in(List<S> list) {
        return this.in(list.toArray());
    }

    public <S> PlainFS notIn(List<S> list) {
        return this.notIn(list.toArray());
    }

    public <S> PlainFS in(String column, List<S> args) {
        return this.in(column, args.toArray());
    }

    public <S> PlainFS notIn(String column, List<S> args) {
        return this.notIn(column, args.toArray());
    }

    public <S> PlainFS andIn(String column, List<S> args) {
        return this.andIn(column, args.toArray());
    }

    public <S> PlainFS andNotIn(String column, List<S> args) {
        return this.andNotIn(column, args.toArray());
    }

    public PlainFS order(String order) {
        String orderTemp;
        if (StrKit.isBlank(order)) {
            throw new HORMException("order is empty");
        }
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        String newOrder = orderTemp = order.trim();
        String column = null;
        String flag = null;
        int index = orderTemp.indexOf(" ");
        if (index > -1) {
            column = orderTemp.substring(0, index);
            flag = orderTemp.substring(index);
            newOrder = this.mapColumn(column) + " " + flag;
        }
        this.orderBySQL.append(' ').append(newOrder);
        return this;
    }

    public PlainFS order(String columnName, OrderBy orderBy) {
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        String trueColumnName = this.mapColumn(columnName);
        this.orderBySQL.append(' ').append(trueColumnName).append(' ').append(orderBy.toString());
        return this;
    }

    public PlainFS groupByExp(String exps) {
        if (this.groupBySQL.length() > 0) {
            throw new HORMException("group by sql can only be set once.");
        }
        if (exps == null) {
            throw new HORMException("groupBy \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.groupBySQL.append(' ').append(exps);
        return this;
    }

    public PlainFS groupBy(String ... columnNames) {
        if (this.groupBySQL.length() > 0) {
            throw new HORMException("group by sql can only be set once.");
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new HORMException("groupBy \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String columnName : columnNames) {
            String trueColumnName = this.mapColumn(columnName);
            this.groupBySQL.append(' ').append(trueColumnName).append(",");
        }
        this.groupBySQL.deleteCharAt(this.groupBySQL.length() - 1);
        return this;
    }

    public PlainFS set(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.updateColumns.put(trueColumnName, this.convertValue(column, value));
        return this;
    }

    public PlainFS set(Map<String, Object> updateColumns) {
        if (updateColumns != null && !updateColumns.isEmpty()) {
            updateColumns.forEach(this::set);
        }
        return this;
    }

    public PlainFS inc(String column, Number count) {
        String trueColumnName = this.mapColumn(column);
        String exp = trueColumnName + " + " + count;
        this.setExp(trueColumnName, exp);
        return this;
    }

    public PlainFS dec(String column, Number count) {
        String trueColumnName = this.mapColumn(column);
        String exp = trueColumnName + " - " + count;
        this.setExp(trueColumnName, exp);
        return this;
    }

    public PlainFS inc(String column) {
        return this.inc(column, 1);
    }

    public PlainFS dec(String column) {
        return this.dec(column, 1);
    }

    public PlainFS setExp(String column, String exp) {
        String trueColumnName = this.mapColumn(column);
        this.updateColumnExpression.put(trueColumnName, exp);
        return this;
    }

    public PlainFS orNest(Function<PlainFS, PlainFS> func) {
        return this.or().nest(func);
    }

    public PlainFS andNest(Function<PlainFS, PlainFS> func) {
        return this.and().nest(func);
    }

    public PlainFS nest(Function<PlainFS, PlainFS> func) {
        this.conditionSQL.append("(");
        func.apply(this);
        this.conditionSQL.append(")");
        return this;
    }

    public PlainFS and() {
        this.conditionSQL.append(AND_STR);
        return this;
    }

    public PlainFS or() {
        this.conditionSQL.append(" OR ");
        return this;
    }

    public PlainFS eq(String column, Object value) {
        this.conditionSQL.append(this.mapColumn(column)).append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS andEq(String column, Object value) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column)).append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public PlainFS ltMeta(String column) {
        this.conditionSQL.append(" < ").append(this.mapColumn(column));
        return this;
    }

    public PlainFS exp(String exp) {
        this.conditionSQL.append(exp);
        return this;
    }

    public PlainFS andExp(String exp) {
        this.conditionSQL.append(AND_STR).append(exp);
        return this;
    }

    public PlainFS ltExp(String exp) {
        this.conditionSQL.append(" < ").append(exp);
        return this;
    }

    public PlainFS lteMeta(String column) {
        this.conditionSQL.append(" <= ").append(this.mapColumn(column));
        return this;
    }

    public PlainFS lteExp(String exp) {
        this.conditionSQL.append(" <= ").append(exp);
        return this;
    }

    public PlainFS ltMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" < ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS andLtMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" < ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS lteMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" <= ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS andLteMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" <= ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS eqMeta(String column) {
        this.conditionSQL.append(" = ").append(this.mapColumn(column));
        return this;
    }

    public PlainFS eqExp(String exp) {
        this.conditionSQL.append(" = ").append(exp);
        return this;
    }

    public PlainFS eqMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" = ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS andEqMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" = ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS gtMeta(String column) {
        this.conditionSQL.append(" > ").append(this.mapColumn(column));
        return this;
    }

    public PlainFS gtExp(String exp) {
        this.conditionSQL.append(" > ").append(exp);
        return this;
    }

    public PlainFS gtMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" > ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS andGtMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" > ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS gteMeta(String column) {
        this.conditionSQL.append(" >= ").append(this.mapColumn(column));
        return this;
    }

    public PlainFS gteExp(String exp) {
        this.conditionSQL.append(" >= ").append(exp);
        return this;
    }

    public PlainFS gteMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" >= ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS andGteMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" >= ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS notEqMeta(String column) {
        this.conditionSQL.append(" != ").append(this.mapColumn(column));
        return this;
    }

    public PlainFS notEqExp(String exp) {
        this.conditionSQL.append(" != ").append(exp);
        return this;
    }

    public PlainFS notEqMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" != ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS andNotEqMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" != ").append(this.mapColumn(column2));
        return this;
    }

    public PlainFS setNull(String column) {
        return this.set(column, null);
    }

    private void setArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (i == args.length - 1) {
                this.conditionSQL.append("?");
            } else {
                this.conditionSQL.append("?, ");
            }
            this.paramValues.add(args[i]);
        }
    }

    private void beforeCheck() {
        if (StrKit.isBlank(this.tableName)) {
            throw new HORMException("table name is null");
        }
    }

    private Object convertValue(TypeHandler<?> typeHandler, Object v) {
        if (typeHandler == null) {
            return v;
        }
        TypedParameter tp = new TypedParameter();
        tp.setParameter(v);
        tp.setTypeHandler(typeHandler);
        return tp;
    }

    private Object convertValue(String column, Object value) {
        return this.convertValue(this.typeHandlerMap.get(column), value);
    }

    public StringBuilder getConditionSQL() {
        return this.conditionSQL;
    }

    public StringBuilder getOrderBySQL() {
        return this.orderBySQL;
    }

    public StringBuilder getGroupBySQL() {
        return this.groupBySQL;
    }

    public StringBuilder getLimitSQL() {
        return this.limitSQL;
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Map<String, Object> getUpdateColumns() {
        return this.updateColumns;
    }

    public Map<String, String> getUpdateColumnExpression() {
        return this.updateColumnExpression;
    }

    public String getSelectColumns() {
        return this.selectColumns;
    }

    public String getSelectExpressionColumns() {
        return this.selectExpressionColumns;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isCount() {
        return this.count;
    }

    public String[] getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, TypeHandler<?>> getTypeHandlerMap() {
        return this.typeHandlerMap;
    }

    public String getPreEscape() {
        return this.preEscape;
    }

    public String getPostEscape() {
        return this.postEscape;
    }

    public String getHint() {
        return this.hint;
    }

    public String getTablePostfix() {
        return this.tablePostfix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

