/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.dialect.impl.ClickHouseDialect;
import cn.sylinx.horm.dialect.impl.Db2Dialect;
import cn.sylinx.horm.dialect.impl.DerbyDialect;
import cn.sylinx.horm.dialect.impl.DuckdbDialect;
import cn.sylinx.horm.dialect.impl.H2Dialect;
import cn.sylinx.horm.dialect.impl.HsqldbDialect;
import cn.sylinx.horm.dialect.impl.MySqlDialect;
import cn.sylinx.horm.dialect.impl.OracleDialect;
import cn.sylinx.horm.dialect.impl.PostgreSQLDialect;
import cn.sylinx.horm.dialect.impl.SqlServerDialect;
import cn.sylinx.horm.dialect.impl.SqliteDialect;
import cn.sylinx.horm.dialect.spi.DialectSPIManager;

public final class DialectFactory
extends Enum<DialectFactory> {
    private static final /* synthetic */ DialectFactory[] $VALUES;

    public static DialectFactory[] values() {
        return (DialectFactory[])$VALUES.clone();
    }

    public static DialectFactory valueOf(String name) {
        return Enum.valueOf(DialectFactory.class, name);
    }

    public static Dialect createDialect(DbType dbType) {
        switch (dbType.getValue()) {
            case "mysql": {
                return new MySqlDialect();
            }
            case "oracle": {
                return new OracleDialect();
            }
            case "sqlserver": {
                return new SqlServerDialect();
            }
            case "derby": {
                return new DerbyDialect();
            }
            case "postgresql": {
                return new PostgreSQLDialect();
            }
            case "db2": {
                return new Db2Dialect();
            }
            case "h2": {
                return new H2Dialect();
            }
            case "clickhouse": {
                return new ClickHouseDialect();
            }
            case "sqlite": {
                return new SqliteDialect();
            }
            case "hsqldb": {
                return new HsqldbDialect();
            }
            case "duckdb": {
                return new DuckdbDialect();
            }
        }
        return DialectFactory.createDialectBySPI(dbType.getValue());
    }

    private static Dialect createDialectBySPI(String dbType) {
        return DialectSPIManager.createDialectBySPI(dbType);
    }

    public static Dialect createDialect(String dbTypeName) {
        return DialectFactory.createDialect(DbType.getDbType(dbTypeName));
    }

    private static /* synthetic */ DialectFactory[] $values() {
        return new DialectFactory[0];
    }

    static {
        $VALUES = DialectFactory.$values();
    }
}

