/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core.datasource;

import cn.sylinx.horm.core.datasource.DataSourceShutterManager;
import cn.sylinx.horm.dialect.DbType;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedDataSource {
    private static final Logger logger = LoggerFactory.getLogger(NamedDataSource.class);
    public static final String CURRENT_DATASOURCE_NAME = "current_datasource_name";
    private DataSource dataSource;
    private String dataSourceName = "_DEFAULT_DS_NAME_FOR_HORM_";
    private DbType dbType;

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public void close() {
        boolean ok = DataSourceShutterManager.INSTANCE.close(this.dataSource);
        if (ok) {
            logger.info("The datasource -> {}, type -> {} closed", (Object)this.dataSourceName, (Object)this.dbType.getValue());
        }
    }

    public static NamedDataSource create(DataSource dataSource, String dataSourceName, DbType dbType) {
        NamedDataSource nds = new NamedDataSource();
        nds.setDataSource(dataSource);
        nds.setDataSourceName(dataSourceName);
        nds.setDbType(dbType);
        return nds;
    }

    public String toString() {
        return "NamedDataSource [dataSource=" + this.dataSource + ", dataSourceName=" + this.dataSourceName + ", dbType=" + this.dbType + "]";
    }
}

