/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core;

import cn.sylinx.horm.core.OrmClient;
import cn.sylinx.horm.core.datasource.ConnectionProvider;
import cn.sylinx.horm.core.datasource.TransactionalConnectionProvider;
import cn.sylinx.horm.exception.ErrorCodeRecordable;
import cn.sylinx.horm.exception.TransactionException;
import cn.sylinx.horm.transaction.jdbc.ITransactionBlock;
import cn.sylinx.horm.transaction.jdbc.TransactionSupport;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Ret;

public class TransactionSupportOrmClient
extends OrmClient
implements TransactionSupport {
    @Override
    public Ret transaction(ITransactionBlock transaction) {
        ConnectionProvider connectionProvider = this.getConnectionProvider();
        if (!(connectionProvider instanceof TransactionalConnectionProvider)) {
            throw new TransactionException("\u4e0d\u652f\u6301\u4e8b\u52a1\u5904\u7406");
        }
        TransactionalConnectionProvider transactionalConnectionProvider = (TransactionalConnectionProvider)connectionProvider;
        this.startTransaction(transactionalConnectionProvider, transaction.transactionIsolation());
        try {
            Ret ret = transaction.run();
            if (ret.isSuccess()) {
                this.commitTransaction(transactionalConnectionProvider);
            } else {
                this.rollbackTransaction(transactionalConnectionProvider);
            }
            return ret;
        }
        catch (Throwable t) {
            this.rollbackTransaction(transactionalConnectionProvider);
            int code = 500;
            if (ErrorCodeRecordable.class.isAssignableFrom(t.getClass())) {
                code = ((ErrorCodeRecordable)((Object)t)).getCode();
            }
            GLog.error("\u4e8b\u52a1\u5904\u7406\u5f02\u5e38", t);
            return Ret.error(code, t.getMessage(), t);
        }
    }

    @Override
    public TransactionSupport getTransactionSupport() {
        return this;
    }

    @Override
    public String toString() {
        return "TransactionSupportOrmClient [DbType --> " + this.getDialect().getDbType().getValue() + ", DataSourceName --> " + this.getDataSourceName() + "]";
    }

    private void startTransaction(TransactionalConnectionProvider transactionalConnectionProvider, int isolationLevel) {
        transactionalConnectionProvider.startTransaction(isolationLevel);
    }

    private void commitTransaction(TransactionalConnectionProvider transactionalConnectionProvider) {
        transactionalConnectionProvider.commitTransaction();
    }

    private void rollbackTransaction(TransactionalConnectionProvider transactionalConnectionProvider) {
        try {
            transactionalConnectionProvider.rollbackTransaction();
        }
        catch (Exception e) {
            GLog.error("\u4e8b\u52a1\u56de\u6eda\u5f02\u5e38", e);
        }
    }
}

