/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core;

import cn.sylinx.horm.core.AbstractSqlClient;
import cn.sylinx.horm.core.common.OrmUtil;
import cn.sylinx.horm.core.common.Page;
import cn.sylinx.horm.core.common.PreparedCallable;
import cn.sylinx.horm.core.common.Record;
import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.dialect.fs.PlainFS;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.base.BaseModel;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.DefaultSqlParser;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.transaction.jdbc.TransactionSupport;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.util.DbKit;
import cn.sylinx.horm.util.ExceptionCatcher;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.Tuple;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrmClient
extends AbstractSqlClient {
    private Dialect dialect;
    private SqlParser sqlParser = new DefaultSqlParser();

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public TransactionSupport getTransactionSupport() {
        throw new UnsupportedOperationException();
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public void setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    @Override
    public <T, R> List<R> queryForSingleColumn(FS<T> fluentSql) {
        Tuple kv = this.getDialect().getSqlBuilder().buildSelectSQL(fluentSql);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        Class modelClass = (Class)kv.getObject(2);
        return this.queryListForSingleColumn(sql, params, modelClass);
    }

    @Override
    public <T, R> R queryFirstForSingleColumn(FS<T> fluentSql) {
        List<R> objectList = this.queryForSingleColumn(fluentSql);
        return objectList != null && !objectList.isEmpty() ? (R)objectList.get(0) : null;
    }

    @Override
    public <T> T queryFirst(FS<T> fluentSql) {
        List<T> dataList = this.query(fluentSql);
        return dataList != null && !dataList.isEmpty() ? (T)dataList.get(0) : null;
    }

    @Override
    public int count(FS<?> fluentSql) {
        Object[] params;
        Pair kv = this.getDialect().getSqlBuilder().buildCountSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Record r = this.queryRecord(sql, params = (Object[])kv.getSecond());
        return r == null ? 0 : Integer.parseInt(r.get(1).toString());
    }

    @Override
    public <T> Page<T> queryPage(FS<T> fluentSql, int pageNumber, int pageSize) {
        Tuple t = this.getDialect().getSqlBuilder().buildSelectSQL(fluentSql);
        String sql = (String)t.getObject(0);
        Object[] params = (Object[])t.getObject(1);
        Class modelClass = (Class)t.getObject(2);
        return this.queryPage(sql, pageNumber, pageSize, params, modelClass);
    }

    @Override
    public Page<Record> queryPage(PlainFS fluentSql, int pageNumber, int pageSize) {
        Tuple t = this.getDialect().getSqlBuilder().buildSelectSQL(fluentSql);
        String sql = (String)t.getObject(0);
        Object[] params = (Object[])t.getObject(1);
        return this.queryPage(sql, pageNumber, pageSize, params);
    }

    @Override
    public <T> List<T> query(FS<T> fluentSql) {
        Tuple kv = this.getDialect().getSqlBuilder().buildSelectSQL(fluentSql);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        Class modelClass = (Class)kv.getObject(2);
        return this.queryList(sql, params, modelClass);
    }

    @Override
    public List<Record> query(PlainFS fluentSql) {
        Tuple kv = this.getDialect().getSqlBuilder().buildSelectSQL(fluentSql);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        return this.queryRecords(sql, params);
    }

    @Override
    public Record queryFirst(PlainFS fluentSql) {
        Tuple kv = this.getDialect().getSqlBuilder().buildSelectSQL(fluentSql);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        return this.queryRecord(sql, params);
    }

    @Override
    public int update(PlainFS fluentSql) {
        Pair kv = this.getDialect().getSqlBuilder().buildUpdateSQL(fluentSql);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        return ExceptionCatcher.call(() -> this.update(sql, params));
    }

    @Override
    public int delete(PlainFS fluentSql) {
        Pair kv = this.getDialect().getSqlBuilder().buildDeleteSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Object[] params = (Object[])kv.getSecond();
        return ExceptionCatcher.call(() -> this.delete(sql, params));
    }

    @Override
    public int count(PlainFS fluentSql) {
        Object[] params;
        Pair kv = this.getDialect().getSqlBuilder().buildCountSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Record r = this.queryRecord(sql, params = (Object[])kv.getSecond());
        return r == null ? 0 : Integer.parseInt(r.get(1).toString());
    }

    @Override
    public Serializable insert(PlainFS fluentSql) {
        Pair kv = this.getDialect().getSqlBuilder().buildInsertSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Object[] params = (Object[])kv.getSecond();
        try {
            Object obj = this.insertForRetrieval(sql, params);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Serializable) {
                return (Serializable)obj;
            }
            return obj.toString();
        }
        catch (Exception e) {
            GLog.error("OrmClient.save fs error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public int update(FS<?> fluentSql) {
        Pair kv = this.getDialect().getSqlBuilder().buildUpdateSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Object[] params = (Object[])kv.getSecond();
        return ExceptionCatcher.call(() -> this.update(sql, params));
    }

    @Override
    public int delete(FS<?> fluentSql) {
        Pair kv = this.getDialect().getSqlBuilder().buildDeleteSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Object[] params = (Object[])kv.getSecond();
        return ExceptionCatcher.call(() -> this.delete(sql, params));
    }

    @Override
    public Serializable insert(FS<?> fluentSql) {
        Pair kv = this.getDialect().getSqlBuilder().buildInsertSQL(fluentSql);
        String sql = (String)kv.getFirst();
        Object[] params = (Object[])kv.getSecond();
        try {
            Object obj = this.insertForRetrieval(sql, params);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Serializable) {
                return (Serializable)obj;
            }
            return obj.toString();
        }
        catch (Exception e) {
            GLog.error("OrmClient.save fs error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public <T> int[] insertBatch(List<T> t) {
        Pair pair = this.getDialect().getSqlBuilder().buildBatchInsertSQL(t);
        String sql = (String)pair.getObject(0);
        List params = (List)pair.getObject(1);
        try {
            return this.insertBatch(sql, params);
        }
        catch (Exception e) {
            GLog.error("OrmClient.insertBatch error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public <T> int insert(T t) {
        if (t instanceof BaseModel && ((BaseModel)t).getGmtCreate() == null) {
            ((BaseModel)t).setGmtCreate(new Date());
        }
        Pair pair = this.getDialect().getSqlBuilder().buildInsertSQL(t);
        String sql = (String)pair.getObject(0);
        Object[] params = (Object[])pair.getObject(1);
        try {
            return this.insert(sql, params);
        }
        catch (Exception e) {
            GLog.error("OrmClient.insert error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public <T> Serializable save(T t) {
        if (t instanceof BaseModel && ((BaseModel)t).getGmtCreate() == null) {
            ((BaseModel)t).setGmtCreate(new Date());
        }
        Pair pair = this.getDialect().getSqlBuilder().buildInsertSQL(t);
        String sql = (String)pair.getObject(0);
        Object[] params = (Object[])pair.getObject(1);
        try {
            Object obj = this.insertForRetrieval(sql, params);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Serializable) {
                return (Serializable)obj;
            }
            return obj.toString();
        }
        catch (Exception e) {
            GLog.error("OrmClient.save error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public <T> int delete(T t) {
        Pair pair = this.getDialect().getSqlBuilder().buildDeleteSQL(t);
        String sql = (String)pair.getObject(0);
        Object[] params = (Object[])pair.getObject(1);
        try {
            return this.delete(sql, params);
        }
        catch (Exception e) {
            GLog.error("OrmClient.delete error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public <T> int update(T t) {
        if (t instanceof BaseModel && ((BaseModel)t).getGmtModify() == null) {
            ((BaseModel)t).setGmtModify(new Date());
        }
        Pair pair = this.getDialect().getSqlBuilder().buildUpdateSQL(t);
        String sql = (String)pair.getObject(0);
        Object[] params = (Object[])pair.getObject(1);
        try {
            return this.update(sql, params);
        }
        catch (Exception e) {
            GLog.error("OrmClient.update error", e);
            throw new HORMException(e);
        }
    }

    @Override
    public int update(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return ExceptionCatcher.call(() -> this.update(sql, paramsArray));
    }

    @Override
    public Serializable insertForRetrieval(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return (Serializable)((Object)ExceptionCatcher.call(() -> {
            Object pk = this.insertForRetrieval(sql, paramsArray);
            if (pk == null) {
                return null;
            }
            return pk.toString();
        }));
    }

    @Override
    public boolean execute(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return ExceptionCatcher.call(() -> this.execute(sql, paramsArray));
    }

    @Override
    public <T> T get(Serializable id, Class<T> modelClass) {
        Object[] params;
        Pair pair = this.getDialect().getSqlBuilder().buildQueryByFieldSQL(Collections.singletonList(Pair.apply((Object)"id", (Object)id)), modelClass);
        String sql = (String)pair.getObject(0);
        List<T> dataList = this.queryList(sql, params = (Object[])pair.getObject(1), modelClass);
        if (dataList != null && !dataList.isEmpty()) {
            return dataList.get(0);
        }
        return null;
    }

    @Override
    public Page<Record> queryPage(String sql, int pageNumber, int pageSize, Object[] params) {
        Tuple t = this.buildPaginatorSql(sql, pageNumber, pageSize, params);
        int totalRow = (Integer)t.getObject(0);
        if (totalRow == 0) {
            Page<Record> emptyPage = new Page<Record>();
            emptyPage.setPageSize(pageSize);
            return emptyPage;
        }
        int totalPage = (Integer)t.getObject(1);
        String sqlLimit = (String)t.getObject(2);
        Object[] finalParams = (Object[])t.getObject(3);
        List<Record> dataList = this.queryRecords(sqlLimit, finalParams);
        return new Page<Record>(dataList, pageNumber, pageSize, totalPage, totalRow);
    }

    @Override
    public Page<Record> queryPage(ClasspathSqlResource sqlResource, int pageNumber, int pageSize, Map<String, Object> params) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return this.queryPage(sql, pageNumber, pageSize, paramsArray);
    }

    @Override
    public <T> Page<T> queryPage(String sql, int pageNumber, int pageSize, Object[] params, Class<T> clz) {
        Tuple t = this.buildPaginatorSql(sql, pageNumber, pageSize, params);
        int totalRow = (Integer)t.getObject(0);
        if (totalRow == 0) {
            Page emptyPage = new Page();
            emptyPage.setPageSize(pageSize);
            return emptyPage;
        }
        int totalPage = (Integer)t.getObject(1);
        String sqlLimit = (String)t.getObject(2);
        Object[] finalParams = (Object[])t.getObject(3);
        List<T> dataList = this.queryList(sqlLimit, finalParams, clz);
        return new Page<T>(dataList, pageNumber, pageSize, totalPage, totalRow);
    }

    @Override
    public <T> Page<T> queryPage(ClasspathSqlResource sqlResource, int pageNumber, int pageSize, Map<String, Object> params, Class<T> clz) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return this.queryPage(sql, pageNumber, pageSize, paramsArray, clz);
    }

    @Override
    public <R> Page<R> queryPageForSingleColumn(String sql, int pageNumber, int pageSize, Object[] params, Class<R> clz) {
        Tuple t = this.buildPaginatorSql(sql, pageNumber, pageSize, params);
        int totalRow = (Integer)t.getObject(0);
        if (totalRow == 0) {
            Page emptyPage = new Page();
            emptyPage.setPageSize(pageSize);
            return emptyPage;
        }
        int totalPage = (Integer)t.getObject(1);
        String sqlLimit = (String)t.getObject(2);
        Object[] finalParams = (Object[])t.getObject(3);
        List<R> dataList = this.queryListForSingleColumn(sqlLimit, finalParams, clz);
        return new Page<R>(dataList, pageNumber, pageSize, totalPage, totalRow);
    }

    @Override
    public Record queryRecord(String querySql, Object ... params) {
        List<Record> records = this.queryRecords(querySql, params);
        if (records != null && !records.isEmpty()) {
            return records.get(0);
        }
        return null;
    }

    @Override
    public List<Record> queryRecords(String querySql, Object ... params) {
        return this.queryRecordsFromDB(querySql, params);
    }

    private List<Record> queryRecordsFromDB(String querySqlInput, Object ... paramsInput) {
        return this.callSilence((ds, conn, sql, params) -> {
            ArrayList<Record> arrayList;
            ResultSet rs = null;
            PreparedStatement pst = null;
            ArrayList<Record> result = new ArrayList<Record>();
            try {
                pst = conn.prepareStatement(sql);
                this.setParameters(pst, params);
                rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Record tmp = null;
                while (rs.next()) {
                    tmp = new Record();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i), i, rs.getObject(i));
                    }
                    result.add(tmp);
                }
                arrayList = result;
            }
            catch (Throwable throwable) {
                DbKit.closeQuietly(rs, pst);
                throw throwable;
            }
            DbKit.closeQuietly(rs, pst);
            return arrayList;
        }, querySqlInput, paramsInput);
    }

    @Override
    public <T> List<T> queryList(Class<T> modelClass) {
        return this.queryList(this.getDialect().getSqlBuilder().buildSimpleQuery(modelClass), null, modelClass);
    }

    @Override
    public <T> T queryFirst(String querySql, Object[] params, Class<T> modelClass) {
        List<T> dataList = this.queryList(querySql, params, modelClass);
        return dataList != null && !dataList.isEmpty() ? (T)dataList.get(0) : null;
    }

    @Override
    public <T> List<T> queryList(String querySql, Object[] params, Class<T> modelClass) {
        return this.queryListFromDB(querySql, params, modelClass);
    }

    private <T> List<T> queryListFromDB(String querySqlInput, Object[] paramsInput, Class<T> modelClass) {
        Dialect dialect = this.getDialect();
        return this.callSilence((ds, connection, sql, params) -> {
            ArrayList arrayList;
            ArrayList result = new ArrayList();
            ResultSet rs = null;
            PreparedStatement pst = null;
            ModelFabric mf = ModelCacheUtil.getModelFabric(modelClass);
            Map<String, String> mapping = mf.getJdbcMapping();
            Map<String, Field> fieldMap = mf.getFieldMap();
            Map<String, TypeHandler<?>> typeHandlerMap = mf.getTypeHandlerMap();
            try {
                pst = connection.prepareStatement(sql);
                this.setParameters(pst, params);
                rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                String[] labelNames = new String[columnCount + 1];
                for (int i = 1; i < labelNames.length; ++i) {
                    labelNames[i] = rsmetas.getColumnLabel(i);
                }
                while (rs.next()) {
                    Object instance = modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        Object tmp1;
                        Field f = fieldMap.get(mapping.get(labelNames[i]));
                        if (f == null) continue;
                        TypeHandler<?> typeHandler = typeHandlerMap.get(f.getName());
                        Object obj = tmp1 = typeHandler == null ? OrmUtil.getResult(dialect, rs, i, f.getType()) : OrmUtil.getResult(rs, i, typeHandler);
                        if (tmp1 == null) continue;
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                        }
                        f.set(instance, tmp1);
                    }
                    result.add(instance);
                }
                arrayList = result;
            }
            catch (Exception e) {
                try {
                    throw new HORMException(e);
                }
                catch (Throwable throwable) {
                    DbKit.closeQuietly(rs, pst);
                    throw throwable;
                }
            }
            DbKit.closeQuietly(rs, pst);
            return arrayList;
        }, querySqlInput, paramsInput);
    }

    @Override
    public <T> T queryFirstForSingleColumn(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass) {
        List<T> dataList = this.queryListForSingleColumn(sqlResource, params, modelClass);
        if (dataList != null && !dataList.isEmpty()) {
            return dataList.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> queryListForSingleColumn(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return this.queryListForSingleColumn(sql, paramsArray, modelClass);
    }

    @Override
    public <T> T queryFirstForSingleColumn(String querySql, Object[] params, Class<T> modelClass) {
        List<T> dataList = this.queryListForSingleColumn(querySql, params, modelClass);
        if (dataList != null && !dataList.isEmpty()) {
            return dataList.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> queryListForSingleColumn(String querySql, Object[] params, Class<T> modelClass) {
        return this.queryListForSingleColumnFromDB(querySql, params, modelClass);
    }

    private <T> List<T> queryListForSingleColumnFromDB(String querySqlInput, Object[] paramsInput, Class<T> modelClass) {
        Dialect dialect = this.getDialect();
        return this.callSilence((ds, connection, sql, params) -> {
            ArrayList arrayList;
            ArrayList result = new ArrayList();
            ResultSet rs = null;
            PreparedStatement pst = null;
            try {
                pst = connection.prepareStatement(sql);
                this.setParameters(pst, params);
                rs = pst.executeQuery();
                while (rs.next()) {
                    result.add(OrmUtil.getResult(dialect, rs, 1, modelClass));
                }
                arrayList = result;
            }
            catch (Exception e) {
                try {
                    throw new HORMException(e);
                }
                catch (Throwable throwable) {
                    DbKit.closeQuietly(rs, pst);
                    throw throwable;
                }
            }
            DbKit.closeQuietly(rs, pst);
            return arrayList;
        }, querySqlInput, paramsInput);
    }

    @Override
    public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass) {
        List<T> dataList = this.queryList(sqlResource, params, modelClass);
        if (dataList != null && !dataList.isEmpty()) {
            return dataList.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> queryList(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return this.queryList(sql, paramsArray, modelClass);
    }

    @Override
    public Record queryRecord(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        List<Record> records = this.queryRecords(sqlResource, params);
        if (records != null && !records.isEmpty()) {
            return records.get(0);
        }
        return null;
    }

    @Override
    public List<Record> queryRecords(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Pair tp = this.parseSql(sqlResource, params);
        String sql = (String)tp.get(0);
        Object[] paramsArray = (Object[])tp.get(1);
        return this.queryRecords(sql, paramsArray);
    }

    @Override
    public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        return this.sqlParser.parseSql(sqlResource, this.injectParams(params));
    }

    @Override
    public Pair parseSql(String statement, String type, Map<String, Object> params) {
        return this.sqlParser.parseSql(statement, type, this.injectParams(params));
    }

    protected Map<String, Object> injectParams(Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>(8);
        }
        params.put("current_db_type", this.getDialect().getDbType().getValue());
        params.put("current_datasource_name", this.getConnectionProvider().getDataSourceName());
        return params;
    }

    protected <T> T callSilence(PreparedCallable<T> preparedCallable, String sql, Object[] params) {
        try {
            return super.call(preparedCallable, sql, params);
        }
        catch (Exception e) {
            GLog.error("OrmClient.callSilence error", e);
            throw new HORMException(e);
        }
    }

    protected Tuple buildPaginatorSql(String sql, int pageNumber, int pageSize, Object[] params) {
        int totalRow;
        Tuple t = this.getDialect().getSqlBuilder().buildPaginatorSql(sql, pageNumber, pageSize);
        String sqlCount = (String)t.getObject(0);
        Record r = this.queryRecord(sqlCount, params);
        int n = totalRow = r == null ? 0 : Integer.parseInt(r.get("totalCount").toString());
        if (totalRow == 0) {
            return Tuple.apply(0, null, null);
        }
        int totalPage = totalRow / pageSize;
        if (totalRow % pageSize != 0) {
            ++totalPage;
        }
        String sqlLimit = (String)t.getObject(1);
        Object[] pms = (Object[])t.getObject(2);
        int paramSize = params == null ? 0 : params.length;
        int pageParamSize = pms == null ? 0 : pms.length;
        int finalParamSize = paramSize + pageParamSize;
        Object[] finalParams = new Object[finalParamSize];
        if (paramSize > 0) {
            System.arraycopy(params, 0, finalParams, 0, paramSize);
        }
        if (pageParamSize > 0) {
            System.arraycopy(pms, 0, finalParams, paramSize, pageParamSize);
        }
        return Tuple.apply(totalRow, totalPage, sqlLimit, finalParams);
    }

    @Override
    protected void setParameters(PreparedStatement pst, Object ... params) throws SQLException {
        if (params != null) {
            Dialect dialect = this.getDialect();
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                OrmUtil.setParameter(dialect, pst, i + 1, params[i]);
            }
        }
    }

    public String toString() {
        return "OrmClient [DbType --> " + this.getDialect().getDbType().getValue() + ", DataSourceName --> " + this.getDataSourceName() + "]";
    }
}

