/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.core.PreparedCallWrapperManager;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.SqlPrettyHelper;
import cn.sylinx.horm.core.common.Callable;
import cn.sylinx.horm.core.common.PreparedCallWrapper;
import cn.sylinx.horm.core.common.PreparedCallable;
import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.core.datasource.ConnectionProvider;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.DbKit;
import cn.sylinx.horm.util.GLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractSqlClient
implements SqlClient {
    protected ConnectionProvider connectionProvider;

    AbstractSqlClient() {
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public String getDataSourceName() {
        return this.connectionProvider.getDataSourceName();
    }

    @Override
    public void close() {
        this.connectionProvider.close();
    }

    @Override
    public int insert(String insertSql, Object ... params) throws SQLException {
        return this.update(insertSql, params);
    }

    @Override
    public int[] insertBatch(String insertSqlTemplateInput, List<Object[]> batchParamsInput) throws SQLException {
        if (batchParamsInput == null || batchParamsInput.isEmpty()) {
            throw new HORMException("\u6279\u91cf\u63d2\u5165\u53c2\u6570\u4e22\u5931");
        }
        return this.call((d, c, s, p) -> {
            Object object;
            PreparedStatement pst = null;
            try {
                List batchParamsInner = (List)p[0];
                pst = c.prepareStatement(s);
                for (Object[] row : batchParamsInner) {
                    this.setParameters(pst, row);
                    pst.addBatch();
                }
                object = pst.executeBatch();
            }
            catch (Throwable throwable) {
                DbKit.closeQuietly(pst);
                throw throwable;
            }
            DbKit.closeQuietly(pst);
            return object;
        }, insertSqlTemplateInput, new Object[]{batchParamsInput});
    }

    @Override
    public int delete(String deleteSql, Object ... params) throws SQLException {
        return this.update(deleteSql, params);
    }

    @Override
    public int update(String updateSqlInput, Object ... paramsInput) throws SQLException {
        return this.call((d, c, s, p) -> {
            PreparedStatement pst = null;
            try {
                pst = c.prepareStatement(s);
                this.setParameters(pst, p);
                Integer n = pst.executeUpdate();
                return n;
            }
            finally {
                DbKit.closeQuietly(pst);
            }
        }, updateSqlInput, paramsInput);
    }

    @Override
    public Object insertForRetrieval(String insertSqlInput, Object ... paramsInput) throws SQLException {
        return this.call((d, c, s, p) -> {
            Object object;
            ResultSet rs = null;
            PreparedStatement pst = null;
            try {
                pst = c.prepareStatement(s, 1);
                this.setParameters(pst, p);
                int result = pst.executeUpdate();
                if (result < 1) {
                    GLog.debug("0 rows inserted, sql:{}, params:{}", s, p);
                }
                object = (rs = pst.getGeneratedKeys()).next() ? rs.getObject(1) : null;
            }
            catch (Throwable throwable) {
                DbKit.closeQuietly(rs, pst);
                throw throwable;
            }
            DbKit.closeQuietly(rs, pst);
            return object;
        }, insertSqlInput, paramsInput);
    }

    @Override
    public boolean execute(String exeSqlInput, Object ... paramsInput) throws SQLException {
        return this.call((d, c, s, p) -> {
            PreparedStatement pst = null;
            try {
                pst = c.prepareStatement(s);
                if (p != null) {
                    this.setParameters(pst, p);
                }
                Boolean bl = pst.execute();
                return bl;
            }
            finally {
                DbKit.closeQuietly(pst);
            }
        }, exeSqlInput, paramsInput);
    }

    @Override
    public List<Object[]> query(String querySql, Object ... params) throws SQLException {
        return this.queryFromDB(querySql, params);
    }

    private List<Object[]> queryFromDB(String querySqlInput, Object ... paramsInput) throws SQLException {
        return this.call((d, c, s, p) -> {
            ArrayList<Object[]> arrayList;
            PreparedStatement pst = null;
            try {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                pst = c.prepareStatement(s);
                this.setParameters(pst, p);
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                while (rs.next()) {
                    Object[] row = new Object[columnCount];
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        row[i - 1] = rs.getObject(i);
                    }
                    result.add(row);
                }
                arrayList = result;
            }
            catch (Throwable throwable) {
                DbKit.closeQuietly(pst);
                throw throwable;
            }
            DbKit.closeQuietly(pst);
            return arrayList;
        }, querySqlInput, paramsInput);
    }

    @Override
    public List<Object> queryForSingleColumn(String querySql, Object ... params) throws SQLException {
        return this.queryForSingleColumnFromDB(querySql, params);
    }

    private List<Object> queryForSingleColumnFromDB(String querySqlInput, Object ... paramsInput) throws SQLException {
        return this.call((d, c, s, p) -> {
            ArrayList<Object> arrayList;
            PreparedStatement pst = null;
            try {
                ArrayList<Object> result = new ArrayList<Object>();
                pst = c.prepareStatement(s);
                this.setParameters(pst, p);
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    result.add(rs.getObject(1));
                }
                arrayList = result;
            }
            catch (Throwable throwable) {
                DbKit.closeQuietly(pst);
                throw throwable;
            }
            DbKit.closeQuietly(pst);
            return arrayList;
        }, querySqlInput, paramsInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T call(Callable<T> callable) throws SQLException {
        Connection conn = this.connectionProvider.getConnection();
        try {
            T t = callable.call(conn);
            return t;
        }
        finally {
            this.connectionProvider.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T call(PreparedCallable<T> preparedCallable, String sql, Object[] params) throws SQLException {
        PreparedCallable<T> callableDelegate;
        PreparedCallWrapper callWrapper;
        String datasourceName = this.connectionProvider.getDataSourceName();
        Connection conn = this.connectionProvider.getConnection();
        try {
            callWrapper = PreparedCallWrapperManager.getCallWrapper();
            callableDelegate = callWrapper == null ? preparedCallable : callWrapper.wrap(preparedCallable);
            long currentTime = System.currentTimeMillis();
            T t = callableDelegate.call(datasourceName, conn, sql, params);
            if (OrmConfigHolder.isPrintSqlUseTime()) {
                GLog.info("SQL EXECUTE TIME: {}, {}", System.currentTimeMillis() - currentTime, SqlPrettyHelper.output(sql, params));
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.connectionProvider.releaseConnection(conn);
            callableDelegate = null;
            callWrapper = null;
            conn = null;
            datasourceName = null;
        }
    }

    protected void setParameters(PreparedStatement pst, Object ... params) throws SQLException {
        if (params != null) {
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                if (params[i] instanceof TypedParameter) {
                    pst.setObject(i + 1, ((TypedParameter)params[i]).getParameter());
                    continue;
                }
                pst.setObject(i + 1, params[i]);
            }
        }
    }
}

