/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.AviatorFunctionLoader;
import cn.sylinx.horm.config.CommandInterceptorLoader;
import cn.sylinx.horm.config.CommandLoader;
import cn.sylinx.horm.config.MapStrategyLoader;
import cn.sylinx.horm.config.MapperInterceptorLoader;
import cn.sylinx.horm.config.MapperLoader;
import cn.sylinx.horm.config.ModelCacheLoader;
import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.config.ServiceEnvironment;
import cn.sylinx.horm.config.SqlClientInterceptorLoader;
import cn.sylinx.horm.config.TransactionIsolationLoader;
import cn.sylinx.horm.core.interceptor.SqlClientInterceptor;
import cn.sylinx.horm.core.stat.SqlStatManager;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.command.interceptor.CommandInterceptor;
import cn.sylinx.horm.proxy.mapper.interceptor.MapperInterceptor;
import cn.sylinx.horm.util.GLog;
import java.util.concurrent.atomic.AtomicBoolean;

public enum OrmConfigHolder {
    INSTANCE;

    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private OrmConfig ormConfig = new OrmConfig();
    private ServiceEnvironment serviceEnvironment = ServiceEnvironment.NORMAL;
    private SqlClientInterceptor sqlClientInterceptor = null;
    private CommandInterceptor commandInterceptor = null;
    private MapperInterceptor mapperInterceptor = null;

    public static synchronized void init(ServiceEnvironment serviceEnvironment, OrmConfig ormConfig) {
        if (OrmConfigHolder.INSTANCE.initialized.get()) {
            GLog.info("\u5df2\u521d\u59cb\u5316", new Object[0]);
            return;
        }
        try {
            OrmConfigHolder.initInner(serviceEnvironment, ormConfig);
        }
        catch (Exception e) {
            GLog.error("\u521d\u59cb\u5316\u5f02\u5e38", e);
            throw new HORMException("\u521d\u59cb\u5316\u5f02\u5e38", e);
        }
        finally {
            OrmConfigHolder.INSTANCE.initialized.set(true);
        }
    }

    private static void initInner(ServiceEnvironment serviceEnvironment, OrmConfig ormConfig) {
        OrmConfigHolder.INSTANCE.serviceEnvironment = serviceEnvironment;
        OrmConfigHolder.INSTANCE.ormConfig = (OrmConfig)ormConfig.clone();
        OrmConfigHolder.initConfig();
        GLog.info("\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f, OrmConifg:{}", OrmConfigHolder.INSTANCE.ormConfig);
    }

    private static void initConfig() {
        if (OrmConfigHolder.isNormalJavaEnv()) {
            new CommandLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
            new MapperLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
            new TransactionIsolationLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        }
        new MapStrategyLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        if (OrmConfigHolder.isNormalJavaEnv() && !OrmConfigHolder.isDebug() && OrmConfigHolder.INSTANCE.ormConfig.isCacheModelOnStart()) {
            new ModelCacheLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        }
        OrmConfigHolder.INSTANCE.sqlClientInterceptor = new SqlClientInterceptorLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        OrmConfigHolder.INSTANCE.commandInterceptor = new CommandInterceptorLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        OrmConfigHolder.INSTANCE.mapperInterceptor = new MapperInterceptorLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        new AviatorFunctionLoader(OrmConfigHolder.INSTANCE.ormConfig).load();
        if (OrmConfigHolder.isSqlStatOpen()) {
            SqlStatManager.start();
        }
    }

    public static OrmConfig getOrmConfig() {
        return (OrmConfig)OrmConfigHolder.INSTANCE.ormConfig.clone();
    }

    private static boolean isNormalJavaEnv() {
        return ServiceEnvironment.NORMAL == OrmConfigHolder.INSTANCE.serviceEnvironment;
    }

    public static ServiceEnvironment getServiceEnvironment() {
        return OrmConfigHolder.INSTANCE.serviceEnvironment;
    }

    public static String getParseSqlType() {
        return OrmConfigHolder.INSTANCE.ormConfig.getParseSqlType();
    }

    public static boolean isDebug() {
        return OrmConfigHolder.INSTANCE.ormConfig.isDebug();
    }

    public static boolean isCacheKeyMd5() {
        return OrmConfigHolder.INSTANCE.ormConfig.isCacheKeyMd5();
    }

    public static boolean isSqlStatOpen() {
        return OrmConfigHolder.INSTANCE.ormConfig.isSqlStatOpen() && OrmConfigHolder.INSTANCE.ormConfig.getSqlExecuteTimeThreshold() > 100L;
    }

    public static boolean isOptimisticLockEnable() {
        return OrmConfigHolder.INSTANCE.ormConfig.isOptimisticLockEnable();
    }

    public static boolean isCaseSensitive() {
        return OrmConfigHolder.INSTANCE.ormConfig.isCaseSensitive();
    }

    public static boolean isPrintSqlUseTime() {
        return OrmConfigHolder.INSTANCE.ormConfig.isPrintSqlUseTime();
    }

    public static long getSqlExecuteTimeThreshold() {
        return OrmConfigHolder.INSTANCE.ormConfig.getSqlExecuteTimeThreshold();
    }

    public static SqlClientInterceptor getSqlClientInterceptor() {
        return OrmConfigHolder.INSTANCE.sqlClientInterceptor;
    }

    public static boolean hasSqlClientInterceptor() {
        return OrmConfigHolder.INSTANCE.sqlClientInterceptor != null;
    }

    public static CommandInterceptor getCommandInterceptor() {
        return OrmConfigHolder.INSTANCE.commandInterceptor;
    }

    public static boolean hasCommandInterceptor() {
        return OrmConfigHolder.INSTANCE.commandInterceptor != null;
    }

    public static MapperInterceptor getMapperInterceptor() {
        return OrmConfigHolder.INSTANCE.mapperInterceptor;
    }

    public static boolean hasMapperInterceptor() {
        return OrmConfigHolder.INSTANCE.mapperInterceptor != null;
    }

    public static String getSqlPostfix() {
        return OrmConfigHolder.INSTANCE.ormConfig.getSqlPostfix();
    }
}

