/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.proxy.mapper.registrar.MapperRegistrar;
import cn.sylinx.horm.util.StrKit;
import java.util.ArrayList;

class MapperLoader {
    private final OrmConfig ormConfig;

    MapperLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    public void load() {
        String mapperScanPackage = this.ormConfig.getMapperScanPackage();
        String mapperPostfix = this.ormConfig.getMapperPostfix();
        if (StrKit.isBlank(mapperPostfix)) {
            mapperPostfix = ".mapper.xml";
        }
        ArrayList<String> pkgs = new ArrayList<String>();
        if (StrKit.isBlank(mapperScanPackage)) {
            pkgs.add("");
        } else {
            String[] splitPkg;
            for (String s : splitPkg = mapperScanPackage.split(",")) {
                if (StrKit.isBlank(s)) continue;
                pkgs.add(s);
            }
        }
        for (String pkg : pkgs) {
            MapperRegistrar.create().register(pkg, mapperPostfix);
        }
    }
}

