/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.proxy.mapper.interceptor.MapperInterceptor;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class MapperInterceptorLoader {
    private final OrmConfig ormConfig;

    MapperInterceptorLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    public MapperInterceptor load() {
        String mapperInterceptorClass = this.ormConfig.getMapperInterceptorClass();
        if (StrKit.isNotBlank(mapperInterceptorClass)) {
            try {
                Class<?> clz = Class.forName(mapperInterceptorClass, false, ClassUtil.getDefaultClassLoader());
                GLog.info("load Mapper interceptor: {}", mapperInterceptorClass);
                return (MapperInterceptor)clz.newInstance();
            }
            catch (Exception e) {
                GLog.error("command mapper interceptor load error", e);
            }
        }
        GLog.info("NO Mapper Interceptor loaded", new Object[0]);
        return null;
    }
}

