/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.proxy.ProxyObjectRegistry;
import cn.sylinx.horm.proxy.command.annotation.Command;
import cn.sylinx.horm.resource.io.ClassScanner;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

class CommandLoader {
    private final OrmConfig ormConfig;
    private final AtomicInteger count = new AtomicInteger(0);

    CommandLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    private void loadOne(String pkg) {
        if (StrKit.isBlank(pkg)) {
            GLog.warn("horm.config.command-scan-package\u6ca1\u6709\u914d\u7f6e\uff0c\u8fd9\u5c06\u5bfc\u81f4\u82b1\u8d39\u66f4\u591a\u65f6\u95f4\u626b\u63cf\u6574\u4e2a\u9879\u76ee", new Object[0]);
        }
        GLog.info("\u626b\u63cf\u5305:{}, \u5bfb\u627e@Command\u5bf9\u8c61", StrKit.isBlank(pkg) ? "\u6574\u4e2a\u9879\u76ee" : pkg);
        ClassScanner.scanAllPackageByAnnotation(pkg, Command.class).forEach(cmd -> {
            ProxyObjectRegistry.INSTANCE.register(cmd);
            this.count.incrementAndGet();
        });
    }

    public void load() {
        String commandScanPackage = this.ormConfig.getCommandScanPackage();
        ArrayList<String> pkgs = new ArrayList<String>();
        if (StrKit.isBlank(commandScanPackage)) {
            pkgs.add("");
        } else {
            String[] splitPkg;
            for (String s : splitPkg = commandScanPackage.split(",")) {
                if (StrKit.isBlank(s)) continue;
                pkgs.add(s);
            }
        }
        for (String pkg : pkgs) {
            this.loadOne(pkg);
        }
        GLog.info("\u5bfb\u627e@Command\u5bf9\u8c61\u5b8c\u6bd5\uff0c\u603b\u8ba1:{}", this.count.get());
    }
}

