/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.resource.func.aviator.ForeachAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.ForeachNumberAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.ForeachNumberWithSymbolAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.ForeachStringAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.ForeachStringWithSymbolAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.IncResourceAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.IsNullAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.NotNullAviatorFunction;
import cn.sylinx.horm.resource.func.aviator.PlaceholderParserAviatorFunction;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.lang.reflect.Modifier;

class AviatorFunctionLoader {
    private final OrmConfig ormConfig;

    AviatorFunctionLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    void load() {
        AviatorEvaluator.addFunction((AviatorFunction)new ForeachAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new ForeachNumberAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new ForeachNumberWithSymbolAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new ForeachStringAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new ForeachStringWithSymbolAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new PlaceholderParserAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new IncResourceAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new IsNullAviatorFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new NotNullAviatorFunction());
        this.loadUserDefindeFunction();
    }

    private void loadUserDefindeFunction() {
        String functioinClass = this.ormConfig.getFunctionClass();
        if (StrKit.isNotBlank(functioinClass)) {
            String[] functionClassArray;
            for (String fc : functionClassArray = functioinClass.split(",")) {
                this.loadUserDefindeFunctionSingle(fc);
            }
        }
    }

    private void loadUserDefindeFunctionSingle(String fc) {
        if (StrKit.isBlank(fc)) {
            GLog.error("function class is empty", new Object[0]);
            return;
        }
        String functionClass = fc.trim();
        try {
            Class<?> functionClazz = Class.forName(functionClass);
            int modifiers = functionClazz.getModifiers();
            if (AviatorFunction.class.isAssignableFrom(functionClazz) && !Modifier.isAbstract(modifiers)) {
                Object functionObject = functionClazz.newInstance();
                AviatorEvaluator.addFunction((AviatorFunction)((AviatorFunction)functionObject));
                GLog.info("\u52a0\u8f7d\u51fd\u6570\uff1a{}\u6210\u529f", functionClazz.getName());
            } else {
                GLog.warn("invalid function class: {}", functionClazz.getName());
            }
        }
        catch (Exception e) {
            GLog.error("load function error", e);
        }
    }
}

