
package cn.sylinx.horm.type.handler;

import java.io.Reader;
import java.sql.*;

import cn.sylinx.horm.type.JdbcType;

public class ClobReaderTypeHandler extends BaseTypeHandler<Reader> {

    @Override
    protected JdbcType getJdbcTypeMapper() {
        return JdbcType.CLOB;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Reader parameter) throws SQLException {
        ps.setClob(i, parameter);
    }

    @Override
    public Reader getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return toReader(rs.getClob(columnName));
    }

    @Override
    public Reader getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return toReader(rs.getClob(columnIndex));
    }

    @Override
    public Reader getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return toReader(cs.getClob(columnIndex));
    }

    private Reader toReader(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        } else {
            return clob.getCharacterStream();
        }
    }

}
