package cn.sylinx.horm.resource.parse;

import java.util.Collection;
import java.util.Map;

import com.googlecode.aviator.AviatorEvaluator;

public abstract class SystemConditionParser {

    private static final String NOT_NULL_FLAG = "!!";

    private SystemConditionParser() {
    }

    public static boolean testCondition(String express, Map<String, Object> params) {

        if (params == null) {
            return false;
        }

        if (express == null) {
            return false;
        }

        express = express.trim();

        if (express.startsWith(NOT_NULL_FLAG)) {
            // 空判断
            String trueField = express.substring(NOT_NULL_FLAG.length()).trim();
            if ("".equals(trueField)) {
                return false;
            }

            Object value = params.get(trueField);
            if (value == null) {
                return false;
            }

            // 如果是字符串，判断是否是空白字符串
            if (value instanceof String) {
                return !"".equals(value.toString());
            }

            // 如果是collection，判断是否有元素
            if (value instanceof Collection) {
                return !((Collection<?>) value).isEmpty();
            }

            return true;
        }

        return (boolean) AviatorEvaluator.execute(express, params, true);
    }
}
