package cn.sylinx.horm.resource.func.aviator;

import java.util.Map;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;

import cn.sylinx.horm.resource.parse.PlaceholderParser;

/**
 * sql占位符解析
 * 
 * @author johnhan
 *
 */
public class PlaceholderParserAviatorFunction extends AbstractFunction {

    @Override
    public String getName() {
        return "ps_parse";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject sqlAviatorObject) {
        String sql = FunctionUtils.getStringValue(sqlAviatorObject, env);
        return AviatorRuntimeJavaType.valueOf(PlaceholderParser.INSTANCE_QM.parseSql(sql, env));
    }

}
