package cn.sylinx.horm.resource.func.aviator;

import java.util.Map;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorObject;

public class NotNullAviatorFunction extends AbstractFunction {

    @Override
    public String getName() {
        return "not_null";
    }

    // 接收1个参数，如：not_null(inputField)，返回true / false
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject param) {

        Object obj = FunctionUtils.getJavaObject(param, env);
        return obj == null ? AviatorBoolean.FALSE : AviatorBoolean.TRUE;
    }

}
