package cn.sylinx.horm.resource.func.aviator;

import java.util.Map;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.DefaultSqlParser;
import cn.sylinx.horm.resource.parse.SqlParser;

public class IncResourceAviatorFunction extends AbstractFunction {

    @Override
    public String getName() {
        return "inc_resource";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject sqlResource) {

        String sql = FunctionUtils.getStringValue(sqlResource, env);

        Object dbtypeObject = env.get(DbType.PARSE_DB_TYPE);
        DbType dbtype = dbtypeObject == null ? null : DbType.getDbType(dbtypeObject.toString());
        SqlParser sqlParser = new DefaultSqlParser(OrmConfigHolder.getSqlPostfix(), dbtype);
        String result = sqlParser.parseSqlPart(ClasspathSqlResource.applyAviatorResource(sql), env);
        return new AviatorString(result);
    }

}
