package cn.sylinx.horm.proxy.command.invoker;

import java.util.Map;

import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.proxy.command.CommandMethodMetadata;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.util.ExceptionCatcher;
import cn.sylinx.horm.util.Tuple;

class InsertCommandInvoker extends AbstractCommandInvoker {

    @Override
    public Object invoke(CommandMethodMetadata methodMetadata, Tuple tuple) {

        Map<String, Object> params = tuple.getObject(0);
        String truelyDatasource = tuple.getObject(3);
        String nativeSql = methodMetadata.getResource().nativeSql();
        boolean insertForRetrieval = methodMetadata.getResource().insertForRetrieval();
        SqlClient ormClient = getClient(truelyDatasource);
        String parseSqlType = getParseSqlType(methodMetadata.getResource().parseSqlType());
        
        // 使用native sql
        boolean isNativeSql = nativeSql != null && !"".equals(nativeSql.trim());
        if (isNativeSql) {
            Tuple t = ormClient.getSqlParser().parseSql(nativeSql, parseSqlType, params);
            String truelyNativeSql = t.getObject(0);
            Object[] truelyParams = t.getObject(1);
            return ExceptionCatcher
                    .call(() -> insertForRetrieval ? ormClient.insertForRetrieval(truelyNativeSql, truelyParams)
                            : ormClient.update(truelyNativeSql, truelyParams));
        }

        String sql = methodMetadata.getResource().sql();
        return insertForRetrieval ? ormClient.insertForRetrieval(new ClasspathSqlResource(sql, parseSqlType), params)
                : ormClient.update(new ClasspathSqlResource(sql, parseSqlType), params);
    }
}
