package cn.sylinx.horm.proxy.command.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import cn.sylinx.horm.config.ParseSqlType;

/**
 * 
 * @author han
 *
 */
@Documented
@Inherited
@Retention(RUNTIME)
@Target({ METHOD })
public @interface Resource {

    /**
     * 数据源
     * 
     * @return
     */
    String datasource() default "";

    /**
     * sql资源
     * 
     * @return
     */
    String sql() default "";

    /**
     * native sql
     * 
     * @return
     */
    String nativeSql() default "";

    /**
     * sql解析类型
     * 
     * @return
     */
    ParseSqlType parseSqlType() default ParseSqlType.SYSTEM;

    /**
     * 资源类型，默认查询
     * 
     * @return
     */
    ResourceType resourceType() default ResourceType.QUERY;

    /**
     * 插入时是否返回主键
     * 
     * @return
     */
    boolean insertForRetrieval() default false;
}
