package cn.sylinx.horm.proxy;

import java.lang.reflect.Proxy;

public class ProxyFactory<T> {

    private final Class<T> interfaceClass;

    private T proxyInstance = null;

    public ProxyFactory(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    @SuppressWarnings("unchecked")
    protected T newInstance(ProxyObject<T> proxy) {
        if (proxyInstance == null) {
            proxyInstance = (T) Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[] { interfaceClass },
                    proxy);
        }
        return proxyInstance;
    }
}