package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class HsqldbFS<T> extends FS<T> {

    public static <T> FS<T> of(Class<T> modelClass) {
        return new HsqldbFS<T>().init(modelClass);
    }

    public static <T> FS<T> of(Class<T> modelClass, String tablePostfix) {
        return new HsqldbFS<T>().init(modelClass, tablePostfix);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass) {
        return new HsqldbFS<T>().init(tablePrefix, modelClass);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return new HsqldbFS<T>().init(tablePrefix, modelClass, tablePostfix);
    }
}
