package cn.sylinx.horm.core;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import cn.sylinx.horm.core.common.Callable;
import cn.sylinx.horm.core.common.Page;
import cn.sylinx.horm.core.common.Record;
import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.transaction.jdbc.TransactionSupport;

public interface SqlClient extends FluentSqlClient {

    public static SqlClient getDefaultClient() {
        return getClientBy(null);
    }

    public static SqlClient getClientBy(String dsName) {
        return DynamicClient.get(dsName);
    }

    /**
     * 获取事务支持
     * 
     * @return
     */
    public TransactionSupport getTransactionSupport();

    // for sql client begin
    /**
     * 获取数据源
     * 
     * @return
     */
    public String getDataSourceName();

    /**
     * 插入
     * 
     * @param insertSql
     * @param params
     * @return
     * @throws SQLException
     */
    public int insert(final String insertSql, final Object... params) throws SQLException;

    /**
     * 批量插入
     * 
     * @param insertSqlTemplate
     * @param batchParams
     * @return
     * @throws SQLException
     */
    public int[] insertBatch(final String insertSqlTemplate, final List<Object[]> batchParams) throws SQLException;

    /**
     * 删除
     * 
     * @param deleteSql
     * @param params
     * @return
     * @throws SQLException
     */
    public int delete(final String deleteSql, final Object... params) throws SQLException;

    /**
     * 更新
     * 
     * @param updateSql
     * @param params
     * @return
     * @throws SQLException
     */
    public int update(final String updateSql, final Object... params) throws SQLException;

    /**
     * 插入，返回主键
     * 
     * @param insertSql
     * @param params
     * @return
     * @throws SQLException
     */
    public Object insertForRetrieval(final String insertSql, final Object... params) throws SQLException;

    /**
     * 执行
     * 
     * @param exeSql
     * @param params
     * @return
     * @throws SQLException
     */
    public boolean execute(final String exeSql, final Object... params) throws SQLException;

    /**
     * 查询
     * 
     * @param querySql
     * @param params
     * @return
     * @throws SQLException
     */
    public List<Object[]> query(final String querySql, final Object... params) throws SQLException;

    /**
     * 查询单列
     * 
     * @param querySql
     * @param params
     * @return
     * @throws SQLException
     */
    public List<Object> queryForSingleColumn(final String querySql, final Object... params) throws SQLException;

    /**
     * 自定义操作
     * 
     * @param <T>
     * @param callable
     * @return
     * @throws SQLException
     */
    public <T> T call(Callable<T> callable) throws SQLException;
    // for sql client end

    // for orm client begin
    public Dialect getDialect();

    public SqlParser getSqlParser();

    public <T> Serializable save(T t);

    public <T> int insert(T t);

    public <T> int[] insertBatch(List<T> t);

    public Serializable insertForRetrieval(ClasspathSqlResource sqlResource, Map<String, Object> params);

    public <T> int delete(T t);

    public <T> int update(T t);

    public int update(ClasspathSqlResource sqlResource, Map<String, Object> params);

    public boolean execute(ClasspathSqlResource sqlResource, Map<String, Object> params);

    public <T> T get(Serializable id, Class<T> modelClass);

    public Page<Record> queryPage(String sql, int pageNumber, int pageSize, Object[] params);

    public Page<Record> queryPage(ClasspathSqlResource sqlResource, int pageNumber, int pageSize,
            Map<String, Object> params);

    public <T> Page<T> queryPage(String sql, int pageNumber, int pageSize, Object[] params, Class<T> clz);

    public <T> Page<T> queryPage(ClasspathSqlResource sqlResource, int pageNumber, int pageSize,
            Map<String, Object> params, Class<T> clz);

    public <R> Page<R> queryPageForSingleColumn(String sql, int pageNumber, int pageSize, Object[] params,
            Class<R> clz);

    public Record queryRecord(String querySql, Object... params);

    public List<Record> queryRecords(String querySql, Object... params);

    public <T> List<T> queryList(Class<T> modelClass);

    public <T> T queryFirst(final String querySql, final Object[] params, Class<T> modelClass);

    public <T> List<T> queryList(final String querySql, final Object[] params, Class<T> modelClass);

    public <T> T queryFirstForSingleColumn(ClasspathSqlResource sqlResource, Map<String, Object> params,
            Class<T> modelClass);

    public <T> List<T> queryListForSingleColumn(ClasspathSqlResource sqlResource, Map<String, Object> params,
            Class<T> modelClass);

    public <T> T queryFirstForSingleColumn(final String querySql, final Object[] params, Class<T> modelClass);

    public <T> List<T> queryListForSingleColumn(final String querySql, final Object[] params, Class<T> modelClass);

    public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass);

    public <T> List<T> queryList(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass);

    public Record queryRecord(ClasspathSqlResource sqlResource, Map<String, Object> params);

    public List<Record> queryRecords(ClasspathSqlResource sqlResource, Map<String, Object> params);
    // for orm client end
}