package cn.sylinx.horm.cache.impl;

import cn.sylinx.horm.util.GLog;

public class GuavaCacheConfig implements Cloneable {

    public static final long DEFAULT_EXPIRE_AFTER_WRITE = 5;
    public static final long DEFAULT_MAXIMUM_SIZE = 2000;

    // 默认5分钟过期
    private long expireAfterWrite = DEFAULT_EXPIRE_AFTER_WRITE;
    // 最大2000个缓存键
    private long maximumSize = DEFAULT_MAXIMUM_SIZE;

    public long getExpireAfterWrite() {
        return expireAfterWrite;
    }

    public void setExpireAfterWrite(long expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public long getMaximumSize() {
        return maximumSize;
    }

    public void setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            GLog.error("clone error", e);
            return createCloneObject();
        }
    }

    private GuavaCacheConfig createCloneObject() {
        GuavaCacheConfig c = new GuavaCacheConfig();
        c.setExpireAfterWrite(expireAfterWrite);
        c.setMaximumSize(maximumSize);
        return c;
    }

    @Override
    public String toString() {
        return "GuavaCacheConfig [expireAfterWrite=" + expireAfterWrite + ", maximumSize=" + maximumSize + "]";
    }
}