package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.sylinx.horm.type.JdbcTypeMapper;

public abstract class BaseTypeHandler<T> implements TypeHandler<T> {

    protected abstract JdbcTypeMapper getJdbcTypeMapper();

    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter) throws SQLException {

        if (parameter == null) {

            JdbcTypeMapper jdbcTypeMapper = getJdbcTypeMapper();

            try {
                ps.setNull(i, jdbcTypeMapper.getJdbcTypeCode());
            } catch (SQLException e) {
                ps.setObject(i, null);
            }

        } else {

            setNonNullParameter(ps, i, parameter);
        }
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        T result = getNullableResult(rs, columnName);
        if (rs.wasNull()) {
            return null;
        } else {
            return result;
        }
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        T result = getNullableResult(rs, columnIndex);

        if (rs.wasNull()) {
            return null;
        } else {
            return result;
        }
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        T result = getNullableResult(cs, columnIndex);
        if (cs.wasNull()) {
            return null;
        } else {
            return result;
        }
    }

    public abstract void setNonNullParameter(PreparedStatement ps, int i, T parameter) throws SQLException;

    public abstract T getNullableResult(ResultSet rs, String columnName) throws SQLException;

    public abstract T getNullableResult(ResultSet rs, int columnIndex) throws SQLException;

    public abstract T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException;

}
