package cn.sylinx.horm.type.derby;

import cn.sylinx.horm.type.TypeHandlerRegistry;
import cn.sylinx.horm.type.handler.UnknownTypeHandler;

public class DerbyTypeHandlerRegistry extends TypeHandlerRegistry {

    private static final DerbyUnknownTypeHandler UNKNOWN_TYPE_HANDLER = new DerbyUnknownTypeHandler();

    @Override
    protected void registerSystemTypeHandler() {
        super.registerSystemTypeHandler();
        register(Object.class, new DerbyObjectTypeHandler());
    }

    @Override
    public UnknownTypeHandler getUnknownTypeHandler() {
        return UNKNOWN_TYPE_HANDLER;
    }

}
