package cn.sylinx.horm.resource.parse;

import java.util.Map;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.util.Pair;

public abstract class SqlParser {

    public abstract DbType getDbtype();

    public abstract void setDbtype(DbType dbtype);

    public abstract String getSqlPostfix();

    public abstract void setSqlPostfix(String sqlPostfix);

    /**
     * 解析sql 和 预编译参数
     * 
     * @param sqlResource
     * @param params
     * @return
     */
    public abstract Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params);

    /**
     * 解析sql 和 预编译参数
     * 
     * @param statement
     * @param type
     * @param params
     * @return
     */
    public abstract Pair parseSql(String statement, String type, Map<String, Object> params);

    /**
     * 只解析sql部分，预编译参数不解析
     * @param sqlResource
     * @param params
     * @return
     */
    public abstract String parseSqlPart(ClasspathSqlResource sqlResource, Map<String, Object> params);
    
    /**
     * 只解析sql部分，预编译参数不解析
     * 
     * @param statement
     * @param type
     * @param params
     * @return
     */
    public abstract String parseSqlPart(String statement, String type, Map<String, Object> params);

}