package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.resource.lexer.INCToken;

/**
 * INC 描述
 * 
 * @author johnhan
 *
 */
public class INCNode implements ParsedNode {

    private INCToken incToken;

    public INCNode(INCToken incToken) {
        this.incToken = incToken;
    }

    public INCToken getIncToken() {
        return incToken;
    }

    @Override
    public int getStartIndex() {
        return incToken.getStartIndex();
    }

    @Override
    public int getEndIndex() {
        return incToken.getEndIndex();
    }

    @Override
    public String toString() {
        return "INCNode [incToken=" + incToken + "]";
    }

}
