package cn.sylinx.horm.resource.lexer;

/**
 * 关键字
 * 
 * @author johnhan
 *
 */
public abstract class KeywordToken implements Token {

    private String lexerme;
    private int lineNo;
    private int startIndex;
    private int endIndex;
    private String content;

    public KeywordToken(String lexerme, int lineNo, int startIndex, int endIndex) {
        this.lexerme = lexerme;
        this.lineNo = lineNo;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public String getLexerme() {
        return lexerme;
    }

    public void setLexerme(String lexerme) {
        this.lexerme = lexerme;
    }

    public int getLineNo() {
        return lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getStartIndex() {
        return startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public abstract boolean needSquareBracketContent();

    @Override
    public String toString() {
        return "KeywordToken [lexerme=" + lexerme + ", lineNo=" + lineNo + ", startIndex=" + startIndex + ", endIndex="
                + endIndex + ", content=" + content + "]";
    }

}
