package cn.sylinx.horm.model.anno;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

/**
 * 乐观锁字段，对应字段的类型：
 * 
 * <pre>
 * java.lang.Integer
 * java.lang.Long
 * java.math.BigInteger
 * java.math.BigDecimal
 * </pre>
 * 
 * @author han
 *
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface Version {

    public final static Class<?> VERSION_TYPE_INTEGER_PRIMARY = int.class;
    public final static Class<?> VERSION_TYPE_LONG_PRIMARY = long.class;
    public final static Class<?> VERSION_TYPE_INTEGER = Integer.class;
    public final static Class<?> VERSION_TYPE_LONG = Long.class;
    public final static Class<?> VERSION_TYPE_BIGINTEGER = BigInteger.class;
    public final static Class<?> VERSION_TYPE_BIGDECIMAL = BigDecimal.class;

    public final static List<Class<?>> versionClassList = Arrays.asList(VERSION_TYPE_INTEGER, VERSION_TYPE_LONG,
            VERSION_TYPE_BIGINTEGER, VERSION_TYPE_BIGDECIMAL, VERSION_TYPE_INTEGER_PRIMARY, VERSION_TYPE_LONG_PRIMARY);
}
