package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class SqliteFS<T> extends FS<T> {

    public static <T> FS<T> of(Class<T> modelClass) {
        return new SqliteFS<T>().init(modelClass);
    }

    public static <T> FS<T> of(Class<T> modelClass, String tablePostfix) {
        return new SqliteFS<T>().init(modelClass, tablePostfix);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass) {
        return new SqliteFS<T>().init(tablePrefix, modelClass);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return new SqliteFS<T>().init(tablePrefix, modelClass, tablePostfix);
    }

    public FS<T> limit(int offset, int size) {
        if (limitSQL.length() == 0) {
            limitSQL.append(" LIMIT ").append(offset).append(", ").append(offset + size);
        }
        return this;
    }
}
