package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class HsqldbFSBuilder implements FSBuilder {

    @Override
    public <T> FS<T> build(Class<T> modelClass) {
        return HsqldbFS.of(modelClass);
    }

    @Override
    public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
        return HsqldbFS.of(modelClass, tablePostfix);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
        return HsqldbFS.of(tablePrefix, modelClass);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return HsqldbFS.of(tablePrefix, modelClass, tablePostfix);
    }

}
