package cn.sylinx.horm.config.specific;

import cn.sylinx.horm.util.GLog;

public class SpecificConfig implements Cloneable {

    public static final String DS_CONFIG_KEYWORLD = "specific-config";

    // 是否启用缓存
    private Boolean cache;
    // 是否开启SQL统计
    private Boolean sqlStatOpen;
    // 当前数据源是否支持代理
    private Boolean sqlClientInterceptorEnable;

    public boolean isCache() {
        return cache != null && cache.booleanValue();
    }

    public Boolean getCache() {
        return cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public Boolean getSqlStatOpen() {
        return sqlStatOpen;
    }

    public void setSqlStatOpen(Boolean sqlStatOpen) {
        this.sqlStatOpen = sqlStatOpen;
    }

    public boolean isSqlStatOpen() {
        return sqlStatOpen != null && sqlStatOpen.booleanValue();
    }

    public Boolean getSqlClientInterceptorEnable() {
        return sqlClientInterceptorEnable;
    }

    public void setSqlClientInterceptorEnable(Boolean sqlClientInterceptorEnable) {
        this.sqlClientInterceptorEnable = sqlClientInterceptorEnable;
    }

    public boolean isSqlClientInterceptorEnable() {
        return sqlClientInterceptorEnable != null && sqlClientInterceptorEnable.booleanValue();
    }

    @Override
    public Object clone() {
        SpecificConfig clone = null;
        try {
            clone = (SpecificConfig) super.clone();
        } catch (CloneNotSupportedException e) {
            GLog.error("clone error", e);
            return createCloneObject();
        }
        return clone;
    }

    private Object createCloneObject() {
        SpecificConfig c = new SpecificConfig();
        c.setCache(cache);
        c.setSqlStatOpen(sqlStatOpen);
        c.setSqlClientInterceptorEnable(sqlClientInterceptorEnable);
        return c;
    }

    @Override
    public String toString() {
        return "SpecificConfig [cache=" + cache + ", sqlStatOpen=" + sqlStatOpen + ", sqlClientInterceptorEnable="
                + sqlClientInterceptorEnable + "]";
    }
}
