/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.util;

import cn.sylinx.horm.util.GLog;

public abstract class ClassUtil {
    private ClassUtil() {
    }

    public static boolean isClassExist(String className) {
        try {
            Class.forName(className, false, ClassUtil.getDefaultClassLoader());
        }
        catch (Throwable e) {
            GLog.warn("class:" + className + " load error", new Object[0]);
            return false;
        }
        return true;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtil.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

