/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.starter;

import cn.sylinx.horm.config.SingleDataSourceConfig;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.pool.DataSourceWrapperFactory;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.HashMap;
import java.util.Map;

public final class Utils {
    public static NamedDataSource build(SingleDataSourceConfig singleDataSourceConfig) {
        String url = singleDataSourceConfig.getUrl();
        String driver = singleDataSourceConfig.getDriver();
        String dbtype = singleDataSourceConfig.getDbtype();
        if (StrKit.isBlank(url) || StrKit.isBlank(driver) || StrKit.isBlank(dbtype)) {
            throw new HORMException("\u6570\u636e\u6e90\u53c2\u6570\u914d\u7f6e\u4e22\u5931");
        }
        DbType dbTypeEnum = DbType.getDbType(dbtype);
        GLog.debug("Use DbType:{}", dbTypeEnum.getValue());
        String pooltype = singleDataSourceConfig.getPooltype();
        String username = singleDataSourceConfig.getUsername();
        String password = singleDataSourceConfig.getPassword();
        String name = singleDataSourceConfig.getName();
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("dbtype", dbtype);
        dsMap.put("pooltype", pooltype);
        dsMap.put("name", name);
        dsMap.put("url", url);
        dsMap.put("driver", driver);
        dsMap.put("username", username);
        dsMap.put("password", password);
        Map<String, Object> extConfig = singleDataSourceConfig.getPoolConfig();
        NamedDataSource namedDataSource = DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
        return namedDataSource;
    }
}

