/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.starter;

import cn.sylinx.horm.cache.impl.GuavaCacheConfig;
import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.ServiceEnvironment;
import cn.sylinx.horm.config.specific.SpecificConfig;
import cn.sylinx.horm.config.specific.SpecificConfigHolder;
import cn.sylinx.horm.core.DynamicClient;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.pool.DataSourceWrapperFactory;
import cn.sylinx.horm.resource.io.Resources;
import cn.sylinx.horm.starter.DefaultSqlClientInitializor;
import cn.sylinx.horm.starter.SqlClientInitializor;
import cn.sylinx.horm.util.ExceptionCatcher;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.RelaxedPropertyResolver;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CommonStarter {
    public static final String CONFIG_FILE = "h-orm.properties";
    private static final String MULTI_DATASOURCE_PREFIX = "horm.config.datasource.multids[";
    private static final String MULTI_DATASOURCE_KEY_TEMPLATE = "horm.config.datasource.multids[%d].";
    private static final String MULTI_DATASOURCE_SPECIFIC_CONFIG_TEMPLATE = "horm.config.datasource.multids[%d].specific-config.";
    private String config = "h-orm.properties";
    private Properties p;
    private SqlClientInitializor sqlClientInitializor = new DefaultSqlClientInitializor();

    public CommonStarter() {
        this((String)null);
    }

    public CommonStarter(String config) {
        if (config != null && !"".equals(config)) {
            this.config = config;
        }
        this.init();
    }

    public CommonStarter(Properties p) {
        this.p = p;
    }

    private void init() {
        try {
            this.p = Resources.getResourceAsProperties(this.config);
        }
        catch (IOException e) {
            GLog.error("\u521d\u59cb\u5316\u5f02\u5e38", e);
            throw new HORMException("\u521d\u59cb\u5316\u5f02\u5e38", e);
        }
    }

    public void start() {
        Tuple t = this.parseProperties();
        OrmConfig ormConfig = (OrmConfig)t.getObject(0);
        OrmConfigHolder.init(ServiceEnvironment.NORMAL, ormConfig);
        List dataSourceList = (List)t.getObject(1);
        String defaultDatasourceName = this.initSqlClient(dataSourceList, ormConfig);
        this.loadDataSourceSpecificConfig(OrmConfigHolder.getOrmConfig(), defaultDatasourceName);
    }

    private void loadDataSourceSpecificConfig(OrmConfig ormConfig, String defaultDatasourceName) {
        HashMap<String, SpecificConfig> dsSpecificConfigMap = new HashMap<String, SpecificConfig>();
        if (defaultDatasourceName == null) {
            SpecificConfig c = new SpecificConfig();
            c.setCache(ormConfig.isCache());
            c.setSqlStatOpen(ormConfig.isSqlStatOpen());
            c.setSqlClientInterceptorEnable(true);
            dsSpecificConfigMap.put("_DEFAULT_DS_NAME_FOR_HORM_", c);
        } else {
            int count = this.getMultiDataSourceCount();
            String keyTemplate = MULTI_DATASOURCE_KEY_TEMPLATE;
            String specificConfigKeyTemplate = MULTI_DATASOURCE_SPECIFIC_CONFIG_TEMPLATE;
            for (int i = 0; i < count; ++i) {
                String keyPrefix = String.format(keyTemplate, i);
                String specificConfigKey = String.format(specificConfigKeyTemplate, i);
                String name = this.getProperty(keyPrefix + "name");
                SpecificConfig dsSpecificConfig = this.loadOneDataSourceSpecificConfig(ormConfig, specificConfigKey);
                dsSpecificConfigMap.put(name, dsSpecificConfig);
                if (!defaultDatasourceName.equals(name)) continue;
                dsSpecificConfigMap.put("_DEFAULT_DS_NAME_FOR_HORM_", dsSpecificConfig);
            }
        }
        if (!dsSpecificConfigMap.isEmpty()) {
            SpecificConfigHolder.init(ormConfig, dsSpecificConfigMap);
        }
    }

    private SpecificConfig loadOneDataSourceSpecificConfig(OrmConfig ormConfig, String specificConfigKey) {
        SpecificConfig c = new SpecificConfig();
        c.setCache(ormConfig.isCache());
        c.setSqlStatOpen(ormConfig.isSqlStatOpen());
        c.setSqlClientInterceptorEnable(true);
        String cache = this.getProperty(specificConfigKey + "cache", "true");
        c.setCache(ExceptionCatcher.call(() -> Boolean.valueOf(cache)));
        String sqlStatOpen = this.getProperty(specificConfigKey + "sql-stat-open", "true");
        c.setSqlStatOpen(ExceptionCatcher.call(() -> Boolean.valueOf(sqlStatOpen)));
        String sqlClientInterceptorEnable = this.getProperty(specificConfigKey + "sql-client-interceptor-enable", "true");
        c.setSqlClientInterceptorEnable(ExceptionCatcher.call(() -> Boolean.valueOf(sqlClientInterceptorEnable)));
        return c;
    }

    private String initSqlClient(List<NamedDataSource> dataSourceList, OrmConfig ormConfig) {
        if (dataSourceList == null || dataSourceList.isEmpty()) {
            throw new HORMException("\u6570\u636e\u6e90\u4fe1\u606f\u4e22\u5931");
        }
        if (!this.isMultiple()) {
            DynamicClient.register(this.initOneSqlClient(dataSourceList.get(0), ormConfig));
            return null;
        }
        ArrayList<NamedDataSourcePrimary> transferdNdsp = new ArrayList<NamedDataSourcePrimary>();
        int primaryMult = 0;
        NamedDataSourcePrimary primaryed = null;
        for (NamedDataSource namedDataSource : dataSourceList) {
            NamedDataSourcePrimary ndsp2 = (NamedDataSourcePrimary)namedDataSource;
            if (ndsp2.isPrimary()) {
                primaryed = ndsp2;
                ++primaryMult;
            }
            if (primaryMult > 1) {
                throw new HORMException("primary datasource should be only one!");
            }
            transferdNdsp.add(ndsp2);
        }
        NamedDataSourcePrimary primaryJumpQueue = null;
        if (primaryed == null) {
            primaryed = (NamedDataSourcePrimary)transferdNdsp.get(0);
        }
        primaryJumpQueue = new NamedDataSourcePrimary();
        primaryJumpQueue.setDataSource(primaryed.getDataSource());
        primaryJumpQueue.setDataSourceName("_DEFAULT_DS_NAME_FOR_HORM_");
        primaryJumpQueue.setDbType(primaryed.getDbType());
        primaryJumpQueue.setPrimary(true);
        GLog.info("default SqlClient --> [" + primaryed.getDataSourceName() + "]", new Object[0]);
        transferdNdsp.add(primaryJumpQueue);
        transferdNdsp.forEach(ndsp -> DynamicClient.register(this.initOneSqlClient((NamedDataSource)ndsp, ormConfig)));
        return primaryed.getDataSourceName();
    }

    private SqlClient initOneSqlClient(NamedDataSource signleNamedDataSource, OrmConfig ormConfig) {
        return this.sqlClientInitializor.initSqlClient(signleNamedDataSource, ormConfig);
    }

    private Tuple parseProperties() {
        ArrayList<NamedDataSource> dataSourceList = new ArrayList<NamedDataSource>();
        OrmConfig ormConfig = new OrmConfig();
        boolean multiple = this.isMultiple();
        boolean isParseSqlPathDbtype = this.isParseSqlPathDbtype();
        ormConfig.setParseSqlPathDbtype(isParseSqlPathDbtype);
        if (!multiple) {
            dataSourceList.add(this.checkAndGetSingleNamedDataSource());
        } else {
            dataSourceList.addAll(this.checkAndGetMultiNamedDataSource());
        }
        this.setAppConfigs(ormConfig);
        return Tuple.apply(ormConfig, dataSourceList);
    }

    private void setAppConfigs(OrmConfig ormConfig) {
        String commandInterceptorClass;
        String mapperInterceptorClass;
        boolean cache = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty("horm.config.cache", "false")));
        ormConfig.setCache(cache);
        boolean cacheModelOnStart = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty("horm.config.cache-model-on-start", "false")));
        ormConfig.setCacheModelOnStart(cacheModelOnStart);
        String commandScanPackage = this.getProperty("horm.config.command-scan-package");
        ormConfig.setCommandScanPackage(commandScanPackage);
        boolean debug = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty("horm.config.debug", "false")));
        ormConfig.setDebug(debug);
        if (cache) {
            GuavaCacheConfig guavaCacheConfig = new GuavaCacheConfig();
            String expireAfterWriteStr = this.getProperty("horm.config.guava-cache-config.expire-after-write", String.valueOf(5L));
            long expireAfterWrite = ExceptionCatcher.call(() -> Long.valueOf(expireAfterWriteStr));
            guavaCacheConfig.setExpireAfterWrite(expireAfterWrite);
            String maximumSizeStr = this.getProperty("horm.config.guava-cache-config.maximum-size", String.valueOf(2000L));
            long maximumSize = ExceptionCatcher.call(() -> Long.valueOf(maximumSizeStr));
            guavaCacheConfig.setMaximumSize(maximumSize);
            ormConfig.setGuavaCacheConfig(guavaCacheConfig);
        }
        String modelMapStrategy = this.getProperty("horm.config.model-map-strategy");
        ormConfig.setModelMapStrategy(modelMapStrategy);
        String modelScanPackage = this.getProperty("horm.config.model-scan-package");
        ormConfig.setModelScanPackage(modelScanPackage);
        String mapperScanPackage = this.getProperty("horm.config.mapper-scan-package");
        ormConfig.setMapperScanPackage(mapperScanPackage);
        String mapperPostfix = this.getProperty("horm.config.mapper-postfix");
        if (!StrKit.isBlank(mapperPostfix)) {
            ormConfig.setMapperPostfix(mapperPostfix);
        }
        boolean caseSensitive = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty("horm.config.case-sensitive", "false")));
        ormConfig.setCaseSensitive(caseSensitive);
        boolean optimisticLockEnable = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty("horm.config.optimistic-lock-enable", "false")));
        ormConfig.setOptimisticLockEnable(optimisticLockEnable);
        String sqlPath = this.getProperty("horm.config.sql-path");
        ormConfig.setSqlPath(sqlPath);
        String sqlPostfix = this.getProperty("horm.config.sql-postfix");
        if (!StrKit.isBlank(sqlPostfix)) {
            ormConfig.setSqlPostfix(sqlPostfix);
        }
        int transactionIsolation = ExceptionCatcher.call(() -> Integer.valueOf(this.getProperty("horm.config.transaction-isolation", "2")));
        ormConfig.setTransactionIsolation(transactionIsolation);
        boolean sqlStatOpen = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty("horm.config.sql-stat-open", "false")));
        ormConfig.setSqlStatOpen(sqlStatOpen);
        String sqlExecuteTimeThresholdStr = this.getProperty("horm.config.sql-execute-time-threshold", String.valueOf(3000L));
        long sqlExecuteTimeThreshold = ExceptionCatcher.call(() -> Long.valueOf(sqlExecuteTimeThresholdStr));
        ormConfig.setSqlExecuteTimeThreshold(sqlExecuteTimeThreshold);
        String interceptorClass = this.getProperty("horm.config.interceptor-class");
        if (!StrKit.isBlank(interceptorClass)) {
            ormConfig.setInterceptorClass(interceptorClass.trim());
        }
        if (!StrKit.isBlank(mapperInterceptorClass = this.getProperty("horm.config.mapper-interceptor-class"))) {
            ormConfig.setMapperInterceptorClass(mapperInterceptorClass.trim());
        }
        if (!StrKit.isBlank(commandInterceptorClass = this.getProperty("horm.config.command-interceptor-class"))) {
            ormConfig.setCommandInterceptorClass(commandInterceptorClass.trim());
        }
    }

    private List<NamedDataSource> checkAndGetMultiNamedDataSource() {
        HashSet<String> nameUnique = new HashSet<String>(8);
        ArrayList<NamedDataSource> dsList = new ArrayList<NamedDataSource>();
        int count = this.getMultiDataSourceCount();
        String keyTemplate = MULTI_DATASOURCE_KEY_TEMPLATE;
        for (int i = 0; i < count; ++i) {
            String keyPrefix = String.format(keyTemplate, i);
            NamedDataSource nds = this.checkAndGetOneNamedDataSource(keyPrefix);
            if (nameUnique.contains(nds.getDataSourceName())) {
                throw new HORMException("datasource name should be unique");
            }
            nameUnique.add(nds.getDataSourceName());
            String primaryKey = keyPrefix + "primary";
            boolean isPrimary = ExceptionCatcher.call(() -> Boolean.valueOf(this.getProperty(primaryKey, "false")));
            NamedDataSourcePrimary ndsp = this.toNamedDataSourcePrimary(nds, isPrimary);
            dsList.add(ndsp);
        }
        return dsList;
    }

    private NamedDataSourcePrimary toNamedDataSourcePrimary(NamedDataSource nds, boolean isPrimary) {
        NamedDataSourcePrimary ndsp = new NamedDataSourcePrimary();
        ndsp.setDataSource(nds.getDataSource());
        ndsp.setDataSourceName(nds.getDataSourceName());
        ndsp.setDbType(nds.getDbType());
        ndsp.setPrimary(isPrimary);
        return ndsp;
    }

    private NamedDataSource checkAndGetOneNamedDataSource(String prifix) {
        boolean isMultiple = this.isMultiple();
        String url = this.checkAndGetProperty(prifix + "url");
        String driver = this.checkAndGetProperty(prifix + "driver");
        String dbtype = this.checkAndGetProperty(prifix + "dbtype");
        DbType dbTypeEnum = DbType.getDbType(dbtype);
        GLog.debug("Use DbType:{}", dbTypeEnum.getValue());
        String pooltype = this.getProperty(prifix + "pooltype");
        String username = this.getProperty(prifix + "username");
        String password = this.getProperty(prifix + "password");
        String name = this.getProperty(prifix + "name");
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("dbtype", dbtype);
        dsMap.put("pooltype", pooltype);
        dsMap.put("name", isMultiple ? name : "_DEFAULT_DS_NAME_FOR_HORM_");
        dsMap.put("url", url);
        dsMap.put("driver", driver);
        dsMap.put("username", username);
        dsMap.put("password", password);
        String extConfigKey = prifix + "pool-config";
        Map<String, Object> extConfig = this.parseExtConfig(extConfigKey);
        NamedDataSource namedDataSource = DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
        return namedDataSource;
    }

    private boolean isParseSqlPathDbtype() {
        return ExceptionCatcher.call(() -> Boolean.valueOf(this.p.getProperty("horm.config.parse-sql-path-dbtype", "false")));
    }

    private boolean isMultiple() {
        return ExceptionCatcher.call(() -> Boolean.valueOf(this.p.getProperty("horm.config.datasource.multiple", "false")));
    }

    private int getMultiDataSourceCount() {
        int max = -1;
        Set<Object> keySet = this.p.keySet();
        for (Object keyObj : keySet) {
            int index;
            String key = keyObj.toString();
            if (!key.startsWith(MULTI_DATASOURCE_PREFIX) || (index = CommonStarter.getMultiDataSourceIndex(key)) <= max) continue;
            max = index;
        }
        if (max < 0) {
            throw new HORMException("invalid multi datasource config");
        }
        return max + 1;
    }

    private static int getMultiDataSourceIndex(String key) {
        String keyReplaced = key.replace(MULTI_DATASOURCE_PREFIX, "");
        int index = keyReplaced.indexOf(93);
        if (index < 1) {
            throw new HORMException("invalid multi datasource config");
        }
        String digitStr = keyReplaced.substring(0, index).trim();
        return Integer.valueOf(digitStr);
    }

    private NamedDataSource checkAndGetSingleNamedDataSource() {
        return this.checkAndGetOneNamedDataSource("horm.config.datasource.default-");
    }

    private Map<String, Object> parseExtConfig(String prefix) {
        return new RelaxedPropertyResolver(this.p, prefix).toMap();
    }

    private String checkAndGetProperty(String key) {
        String v = this.getProperty(key);
        if (StrKit.isBlank(v)) {
            throw new HORMException("[" + key + "]\u672a\u8bbe\u7f6e\u503c");
        }
        return v;
    }

    private String getProperty(String key, String defaultValue) {
        String v = this.getProperty(key);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    private String getProperty(String key) {
        return this.p.getProperty(key);
    }

    public static class NamedDataSourcePrimary
    extends NamedDataSource {
        private boolean primary = false;

        public boolean isPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }
    }
}

