/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import com.googlecode.aviator.AviatorEvaluator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class SqlTokenHandler
implements TokenHandler {
    private static final String NOT_NULL_FLAG = "!!";
    private Map<String, Object> params;

    @Override
    public void setParameterMap(Map<String, Object> parameterMap) {
        this.params = parameterMap;
    }

    @Override
    public Map<String, Object> getParameterMap() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public Object handle(String content) {
        return StrKit.isNotBlank(content) ? (this.params == null ? null : this.getTypedParameter(content)) : null;
    }

    private Object getTypedParameter(String content) {
        Object param = this.params.get(content);
        Object parameterTypeObject = this.params.get(content + "_PT");
        if (parameterTypeObject == null || !(parameterTypeObject instanceof Class)) {
            return param;
        }
        TypedParameter typedParameter = new TypedParameter();
        typedParameter.setParameter(param);
        typedParameter.setParameterType((Class)parameterTypeObject);
        return typedParameter;
    }

    @Override
    public boolean condition(String condition) {
        if (this.params == null) {
            return false;
        }
        if (condition == null) {
            return false;
        }
        if ((condition = condition.trim()).startsWith(NOT_NULL_FLAG)) {
            String trueField = condition.substring(NOT_NULL_FLAG.length()).trim();
            if ("".equals(trueField)) {
                return false;
            }
            Object value = this.params.get(trueField);
            if (value == null) {
                return false;
            }
            if (value instanceof String) {
                return !"".equals(value.toString());
            }
            if (value instanceof Collection) {
                return !((Collection)value).isEmpty();
            }
            return true;
        }
        try {
            Object ret = AviatorEvaluator.execute((String)condition, this.params, (boolean)true);
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
        }
        catch (Exception e) {
            GLog.error("execute error, exp:" + condition, e);
            throw new HORMException("error expression: " + condition);
        }
        return false;
    }
}

