/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.func.FunctionParser;
import cn.sylinx.horm.resource.lexer.IfEndBlockParserImpl;
import cn.sylinx.horm.resource.lexer.IfEndMatcherImpl;
import cn.sylinx.horm.resource.parse.PlaceholderParser;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.Tuple;

public class GenericTokenParser {
    private static final String TOKEN_DY_BEGIN = "${";
    private static final String TOKEN_DY_END = "}";
    private static final String TOKEN_IF_BEGIN = "#IF";
    private TokenHandler handler;

    public GenericTokenParser(TokenHandler handler) {
        this.handler = handler;
    }

    protected String formatPreStatement(String preSt) {
        return preSt.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ");
    }

    public Pair parse(String preSt, boolean format) {
        String preSt1 = format ? this.formatPreStatement(preSt) : preSt;
        String preSt2 = this.parseIfDynamicSql(preSt1);
        String preSt3 = this.parseDynamicPartSql(preSt2);
        String st = this.parseFunctions(preSt3);
        return this.parseSqlAndParameters(st);
    }

    private Pair parseSqlAndParameters(String st) {
        return PlaceholderParser.INSTANCE_DEFAULT.parseSql(st, this.handler.getParameterMap());
    }

    public Tuple parse(String preSt) {
        return this.parse(preSt, true);
    }

    protected String parseFunctions(String st) {
        return new FunctionParser(this.handler).parse(st);
    }

    protected String parseIfDynamicSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseDynamicSqlNext(st, sb);
        return sb.toString();
    }

    protected String parseDynamicPartSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseDynamicPartSqlNext(st, sb);
        return sb.toString();
    }

    private void parseDynamicPartSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new HORMException("statment is null");
        }
        int is = st.indexOf(TOKEN_DY_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }
        String tmp = st.substring(is);
        int is1 = tmp.indexOf(TOKEN_DY_END);
        int ie = is1 + is;
        if (is1 == -1) {
            throw new HORMException("illegal statement");
        }
        String split = st.substring(is + TOKEN_DY_BEGIN.length(), ie);
        String dynamicSql = null;
        Object dynamicObject = this.handler.handle(split);
        if (dynamicObject != null) {
            dynamicSql = dynamicObject.toString();
        }
        String before = st.substring(0, is) + (dynamicSql == null ? "" : dynamicSql);
        sb.append(before);
        String after = st.substring(ie + TOKEN_DY_END.length());
        this.parseDynamicPartSqlNext(after, sb);
    }

    private void parseDynamicSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new HORMException("statment is null");
        }
        int is = st.indexOf(TOKEN_IF_BEGIN);
        if (is == -1) {
            sb.append(st.trim()).append(" ");
            return;
        }
        String left = st.substring(is);
        String split = this.findMatchIfEnd(left);
        int ie = is + split.length();
        boolean bl = split.startsWith("#IF[");
        if (!bl) {
            throw new HORMException("illegal condition statement");
        }
        String before = st.substring(0, is);
        sb.append(before.trim()).append(" ");
        IfEndBlockParserImpl block = new IfEndBlockParserImpl(this.handler);
        sb.append(block.parse(split));
        String after = st.substring(ie);
        this.parseDynamicSqlNext(after, sb);
    }

    private String findMatchIfEnd(String left) {
        IfEndMatcherImpl matcher = new IfEndMatcherImpl();
        return matcher.findMatchIfEnd(left);
    }
}

