/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.func;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.func.FunctionFactory;
import cn.sylinx.horm.resource.func.IFunction;
import cn.sylinx.horm.resource.parse.ValueTokenHandler;
import cn.sylinx.horm.util.Pair;

public class FunctionParser {
    private static char escape = (char)92;
    private static String escapeClose = "\\]";
    private ValueTokenHandler handler;
    public static final String TOKEN_FUN_BEGIN_QUOTE = "[";
    public static final String TOKEN_FUN_BEGIN = "#FUNC[";
    public static final String TOKEN_FUN_END = "]";

    public FunctionParser(ValueTokenHandler handler) {
        this.handler = handler;
    }

    public String parse(String statement) {
        return this.parseDynamicSql(statement).toString();
    }

    private String parseDynamicSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseSqlNext(st, sb);
        return sb.toString();
    }

    private void parseSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new RuntimeException("statment is null");
        }
        int is = st.indexOf(TOKEN_FUN_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }
        String tmp = st.substring(is);
        Pair p = this.parseFunctionContent(tmp);
        int is1 = (Integer)p.getFirst();
        String split = (String)p.getSecond();
        int ie = is1 + is;
        String dynamicSql = this.handFunction(split);
        String before = st.substring(0, is) + (dynamicSql == null ? "" : dynamicSql);
        sb.append(before);
        String after = st.substring(ie + TOKEN_FUN_END.length());
        this.parseSqlNext(after, sb);
    }

    private Pair parseFunctionContent(String left) {
        int startIndex = TOKEN_FUN_BEGIN.length();
        int len = left.length();
        for (int i = 0; i < len; ++i) {
            if (']' != left.charAt(i) || i <= startIndex) continue;
            char pre1 = left.charAt(i - 1);
            if (escape != pre1) {
                return Pair.apply((Object)i, (Object)this.convertEscapeCondition(left.substring(startIndex, i)));
            }
            char pre2 = left.charAt(i - 2);
            if (escape != pre1 || escape != pre2) continue;
            return Pair.apply((Object)i, (Object)this.convertEscapeCondition(left.substring(startIndex, i)));
        }
        throw new HORMException("illegal function statement");
    }

    private String convertEscapeCondition(String con) {
        if (con.contains(escapeClose)) {
            return con.replace(escapeClose, TOKEN_FUN_END);
        }
        return con;
    }

    private String handFunction(String split) {
        int index = split.indexOf(",");
        if (index == -1) {
            throw new HORMException("\u51fd\u6570\u53c2\u6570\u9519\u8bef");
        }
        String alias = split.substring(0, index);
        String input = split.substring(index + 1);
        IFunction af = FunctionFactory.get().getFunction(alias);
        if (af == null) {
            throw new HORMException("\u5bf9\u5e94\u51fd\u6570[" + alias + "]\u4e0d\u5b58\u5728");
        }
        return af.invoke(this.handler, input);
    }
}

