/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core.stat;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.core.stat.SqlExecutedHandlerManager;
import cn.sylinx.horm.core.stat.SqlStatInfo;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

class SqlStatExecutor {
    private volatile ConcurrentHashMap<String, SqlStatInfo> executedSqls = new ConcurrentHashMap();
    private Thread detectSlowlySqlThread = null;
    private AtomicBoolean started = new AtomicBoolean(false);

    SqlStatExecutor() {
    }

    boolean isStarted() {
        return this.started.get();
    }

    void start() {
        if (!this.started.compareAndSet(false, true)) {
            GLog.info("SqlStatExecutor has started.", new Object[0]);
            return;
        }
        GLog.info("SQL\u7edf\u8ba1\u542f\u52a8\u4e2d ... ", new Object[0]);
        this.detectSlowlySqlThread = new Thread(this::detectSlowlySql);
        this.detectSlowlySqlThread.setDaemon(true);
        this.detectSlowlySqlThread.start();
        GLog.info("SQL\u7edf\u8ba1\u5df2\u542f\u52a8", new Object[0]);
    }

    void stop() {
        if (this.started.compareAndSet(true, false) && this.detectSlowlySqlThread != null) {
            GLog.info("SQL\u7edf\u8ba1\u505c\u6b62\u4e2d...", new Object[0]);
            this.detectSlowlySqlThread.interrupt();
        }
    }

    private void receiveSqlBefore(String seq, String datasoureName, String nativeSql, Long time) {
        long current = System.currentTimeMillis();
        if (StrKit.isBlank(seq) || StrKit.isBlank(datasoureName) || StrKit.isBlank(nativeSql) || time > current) {
            GLog.error("\u53c2\u6570\u5f02\u5e38\uff0cseq\uff1a{}\uff0cdatasoureName\uff1a{}\uff0ctime\uff1a{}\uff0cnativeSql\uff1a{}", seq, datasoureName, time, nativeSql);
            return;
        }
        SqlStatInfo sqlStatInfo = new SqlStatInfo();
        sqlStatInfo.setNativeSql(nativeSql);
        sqlStatInfo.setSeq(seq);
        sqlStatInfo.setDatasoureName(datasoureName);
        sqlStatInfo.setTime(time);
        this.executedSqls.put(seq, sqlStatInfo);
    }

    private void receiveSqlAfter(String seq, String datasoureName, String nativeSql, Long usedTime, Throwable error) {
        if (StrKit.isBlank(seq)) {
            GLog.error("\u53c2\u6570\u5f02\u5e38\uff0cseq\uff1a{}", seq);
            return;
        }
        this.executedSqls.remove(seq);
        this.onExecuteDone(seq, datasoureName, nativeSql, usedTime, error);
    }

    void receiveSql(String type, String seq, String datasoureName, String nativeSql, Long time, Throwable error) {
        if (StrKit.isBlank(type)) {
            GLog.error("\u53c2\u6570\u5f02\u5e38\uff0ctype\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            return;
        }
        if ("before".equals(type)) {
            this.receiveSqlBefore(seq, datasoureName, nativeSql, time);
        } else if ("after".equals(type)) {
            this.receiveSqlAfter(seq, datasoureName, nativeSql, time, error);
        } else {
            GLog.error("\u53c2\u6570\u5f02\u5e38\uff0ctype\uff1a{}", type);
        }
    }

    void detectSlowlySql() {
        while (this.detectSlowlySqlThread != null && this.started.get() && !this.detectSlowlySqlThread.isInterrupted()) {
            try {
                for (String seq : this.executedSqls.keySet()) {
                    long threshold;
                    long diff;
                    SqlStatInfo sqlStatInfo = this.executedSqls.get(seq);
                    if (sqlStatInfo == null || (diff = System.currentTimeMillis() - sqlStatInfo.getTime()) <= (threshold = OrmConfigHolder.getSqlExecuteTimeThreshold())) continue;
                    this.executedSqls.remove(seq);
                    this.onExecuteTimeout(sqlStatInfo, threshold);
                }
            }
            catch (Exception e) {
                GLog.error("detectSlowlySql error " + e.getMessage(), e);
            }
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
        this.executedSqls.clear();
        GLog.info("SQL\u7edf\u8ba1\u5df2\u505c\u6b62", new Object[0]);
    }

    protected void onExecuteTimeout(SqlStatInfo sqlStatInfo, long thresholdMillSeconds) {
        SqlExecutedHandlerManager.getSqlExecutedHandler().onTimeout(sqlStatInfo.getDatasoureName(), sqlStatInfo.getNativeSql(), thresholdMillSeconds);
    }

    protected void onExecuteDone(String seq, String datasoureName, String nativeSql, Long usedTime, Throwable error) {
        SqlExecutedHandlerManager.getSqlExecutedHandler().onDone(datasoureName, nativeSql, usedTime, error);
    }
}

