/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core.datasource;

import cn.sylinx.horm.core.datasource.DataSourceShutter;
import cn.sylinx.horm.util.ClassUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.sql.DataSource;

enum DataSourceShutterManager {
    INSTANCE;

    private List<DataSourceShutter> dataSourceShutterList = new ArrayList<DataSourceShutter>();

    private DataSourceShutterManager() {
        this.loadFromService();
    }

    private final void loadFromService() {
        ServiceLoader<DataSourceShutter> serviceLoader = ServiceLoader.load(DataSourceShutter.class, ClassUtil.getDefaultClassLoader());
        if (serviceLoader != null) {
            Iterator<DataSourceShutter> it = serviceLoader.iterator();
            while (it != null && it.hasNext()) {
                this.dataSourceShutterList.add(it.next());
            }
        }
    }

    boolean close(DataSource dataSource) {
        for (DataSourceShutter dataSourceShutter : this.dataSourceShutterList) {
            if (!dataSourceShutter.close(dataSource)) continue;
            return true;
        }
        return false;
    }
}

