/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.io.SqlResourceScanner;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class SqlResourceLoader {
    private OrmConfig ormConfig;

    SqlResourceLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    public void load() {
        String sqlPath = this.ormConfig.getSqlPath();
        if (StrKit.isBlank(sqlPath)) {
            this.load(null);
            return;
        }
        String[] pathArray = sqlPath.split(",");
        List<String> resourcePaths = Arrays.asList(pathArray);
        if (resourcePaths == null) {
            return;
        }
        resourcePaths.stream().filter(StrKit::isNotBlank).forEach(item -> {
            boolean bl = this.load((String)item);
            if (bl) {
                GLog.info("classpath resources:'{}' load ok\uff0csql resource postfix:{}", item, this.ormConfig.getSqlPostfix());
            } else {
                GLog.warn("classpath resources:'{}' loaded, but no resource\uff0csql resource postfix:{}", item, this.ormConfig.getSqlPostfix());
            }
        });
    }

    private String getSqlPostfix() {
        String sqlPostfix = this.ormConfig.getSqlPostfix();
        if (StrKit.isBlank(sqlPostfix)) {
            sqlPostfix = ".sql";
        }
        return sqlPostfix;
    }

    private boolean load(String resourcesPath) {
        SqlResourceScanner ss = new SqlResourceScanner(resourcesPath, this.getSqlPostfix());
        Set<Object> sqlSets = ss.scan(true);
        if (sqlSets == null || sqlSets.isEmpty()) {
            return false;
        }
        for (Object sql : sqlSets) {
            ClasspathSqlResourceManager.load(String.valueOf(sql));
            GLog.info("SQL\u8d44\u6e90:[{}]\u5df2\u52a0\u8f7d ", sql);
        }
        return true;
    }
}

