/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.cache.CacheKitManager;
import cn.sylinx.horm.cache.ICacheKit;
import cn.sylinx.horm.cache.impl.GuavaCacheKit;
import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import java.util.Iterator;
import java.util.ServiceLoader;

class CacheLoader {
    private OrmConfig ormConfig;

    CacheLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    private ICacheKit loadFromService() {
        try {
            Iterator<ICacheKit> cacheIt;
            ServiceLoader<ICacheKit> sl = ServiceLoader.load(ICacheKit.class);
            if (sl != null && (cacheIt = sl.iterator()).hasNext()) {
                return cacheIt.next();
            }
        }
        catch (Exception e) {
            GLog.error("cache load from service error", e);
            return null;
        }
        GLog.info("No CacheKit from service loader", new Object[0]);
        return null;
    }

    private ICacheKit loadFromDefault() {
        boolean bl = ClassUtil.isClassExist("com.google.common.cache.Cache");
        if (!bl) {
            GLog.error("Guava cache not exist, please confirm", new Object[0]);
            return null;
        }
        return new GuavaCacheKit(this.ormConfig.getGuavaCacheConfig());
    }

    void initCache() {
        ICacheKit cacheKit = this.loadFromService();
        if (cacheKit == null) {
            cacheKit = this.loadFromDefault();
        }
        if (cacheKit == null) {
            GLog.info("No Suitable CacheKit", new Object[0]);
            this.ormConfig.setCache(false);
            return;
        }
        CacheKitManager.set(cacheKit);
        GLog.info("Cache inited, use {}", cacheKit.getClass().getName());
    }
}

