/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.cache;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.util.MD5Util;
import java.util.Arrays;
import java.util.Map;

public abstract class CacheKeyGenerator {
    private static final String KEY_SEP = "|";

    private CacheKeyGenerator() {
    }

    public static String generateCacheKey(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        String tmp = null;
        for (Object object : objects) {
            tmp = CacheKeyGenerator.toString(object);
            if (tmp == null) continue;
            sb.append(tmp).append(KEY_SEP);
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - KEY_SEP.length(), sb.length());
        }
        String cacheKey = sb.toString();
        return OrmConfigHolder.isCacheKeyMd5() ? MD5Util.md5(cacheKey) : cacheKey;
    }

    private static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] tmp = (Object[])object;
            if (tmp.length < 1) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tmp.length; ++i) {
                sb.append(CacheKeyGenerator.toString(tmp[i])).append(KEY_SEP);
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - KEY_SEP.length(), sb.length());
            }
            return sb.toString();
        }
        if (object instanceof Map) {
            Map params = (Map)object;
            Object[] objectList = params.keySet().toArray();
            Arrays.sort(objectList);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < objectList.length; ++i) {
                String key = (String)objectList[i];
                Object value = params.get(key);
                sb.append(key).append("=").append(CacheKeyGenerator.toString(value)).append(KEY_SEP);
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - KEY_SEP.length(), sb.length());
            }
            return sb.toString();
        }
        return String.valueOf(object);
    }
}

